# MIT License

# Copyright (c) 2022 Intelligent Systems Lab Org

# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:

# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.

# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

# File author: Shariq Farooq Bhat

import os

import numpy as np
import scipy.io
import torch
from PIL import Image
from torch.utils.data import DataLoader, Dataset
from torchvision import transforms as T


class iBims(Dataset):
    def __init__(self, config):
        #root_folder = config.ibims_root
        self.root_path = config.ibims_root
        file_path = 'train_test_inputs/ibims_test_files_with_gt.txt'
        with open(file_path, 'r') as file:
            lines = file.readlines()
            lines = [line.strip() for line in lines]  # 去除每行的换行符并存储在列表中
            self.file_names = lines
        self.normalize = lambda x : x

    def __getitem__(self, idx):
        image_path = os.path.join(self.root_path, self.file_names[idx].split(' ')[0]) # RGB/88.png 
        depth_path = os.path.join(self.root_path, self.file_names[idx].split(' ')[1]) # depth/88.mat
        rel_invalid = 'mask/' + self.file_names[idx].split(' ')[0].split('/')[1].split('.')[0] + 'invalid.png'
        rel_trans = 'mask/' + self.file_names[idx].split(' ')[0].split('/')[1].split('.')[0] + 'transp.png'
        invalid_mask_path = os.path.join(self.root_path, rel_invalid) # RGB/88.png 
        transp_mask_path = os.path.join(self.root_path, rel_trans) # RGB/88.png 

        img = np.asarray(Image.open(image_path), dtype=np.float32) / 255.0
        # depth = np.asarray(Image.open(depth_path),dtype=np.uint16).astype('float')*50.0/65535
        depth = np.asarray(scipy.io.loadmat(depth_path)['depth'],dtype=np.uint16).astype('float')

        mask_valid = np.asarray(Image.open(invalid_mask_path))
        #mask_valid = ~mask_invalid
        mask_transp = np.asarray(Image.open(transp_mask_path))

        # depth = depth * mask_valid * mask_transp
        depth = np.where(mask_valid * mask_transp, depth, -1)

        img = torch.from_numpy(img).permute(2, 0, 1)
        img = self.normalize(img)
        depth = torch.from_numpy(depth).unsqueeze(0)
        return dict(image=img, depth=depth, image_path=image_path, depth_path=depth_path, dataset='ibims')

    def __len__(self):
        return len(self.file_names)


def get_ibims_loader(config, batch_size=1, **kwargs):
    dataloader = DataLoader(iBims(config), batch_size=batch_size, **kwargs)
    return dataloader
