/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.donors;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.code.CompressionBrotli;
import net.sourceforge.plantuml.code.TranscoderImpl;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.version.PSystemVersion;

public class PSystemDonors
extends AbstractPSystem {
    public static final String DONORS = "6mK70AmER5DRWVz05mqtRsdC3wE5OakdUGahTcCbkRKA_62GTnixOmk2vuhY2Yf0NeWrj-s_RbXK54A7AlohojhVCdtjt3gOud9H7GSveQY5J2TYN0IjrbiiTJefoOCyfvl_omKs9aZlhB4fyl0ue1ip6cFXn6XC-pyg6_HVT0LQmDEeR5bKvfRu4AdqPTSkbKjo1YU8B2kSajPYAeRT8iNTDePvtR93aA_5wuWySVFh6_MYkzbSpLA99n5nZf93r-stzNsdjn-GB838njZek661A2HFUi7OSd2XSWW0oAx9C3QiM7bYG0iVT88_lYWBXRTKOqq7Yihf1H6u_I4AIFgZl1Oncru656ePBUgMDDNnyIMbD9liANzj6exHDqwMc06e2UG_w8dktbPT8ZtZPK0azGt9jsm2ZIJt6jzXeazK7uYJKG3MGpDbF3-ghQMiMbt7-CsZ8TmjbMks6__6AoV47FyUahAuj82y0HqQ2x3a7-XOB7I7TBMo2_Vgd5gyGmG4fqo3XTwcs6l-7xj8CLJ8RcHX3lrql1aDs59NITuWVcg5-AnpWgGiBJuFVPusFfDO4yAuzoNiczKi5Vz_xcLcK8AWZM6eg8i9q9mvjAfDYYW2ju3-ZN1JbxpehhThEzvU3yLhX2xelPDCdBjDZ_PFnGsaQocarK7fT9a9O6coOZQLonO9Ojg1JgFACwuimhxTPLc-R2nvBEmapHgDeMZJtPKdARU7Udet3AdtPlzkxIMj2LoWe31vYHgho6P7z-wuQ5xFOB2xqWCFfCyuvxwNNqhf5e0YosDDbuNY6U47VnwwzCVzMTJ6ukSR_v1NqUDNyfZIMoZlbdX_KvGLFQUaNO38ShqAaSYu2QwF9djgiKpbi8BiMDcY2u-nOR1V2jp20sxhaK5hDgLLlQ-kGn7y45_qeFBQH69sj3iupZ0U1KR7l2DvR8lNaCnUGF4S9dXA9w0nKjAHlXR9o7ijqMsTVloqneNQDhubtEDGUCT4inuRU4u15EoX6m00";

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat, long seed) throws IOException {
        UDrawable result = this.getGraphicStrings();
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, HtmlColorUtils.WHITE, this.getMetadata(), null, 0.0, 0.0, null, false);
        imageBuilder.setUDrawable(result);
        return imageBuilder.writeImageTOBEMOVED(fileFormat, seed, os);
    }

    private UDrawable getGraphicStrings() throws IOException {
        final List<TextBlock> cols = PSystemDonors.getCols(this.getDonors(), 4, 5);
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                TextBlockBackcolored header = GraphicStrings.createBlackOnWhite(Arrays.asList("<b>Special thanks to our sponsors and donors !"));
                header.drawU(ug);
                StringBounder stringBounder = ug.getStringBounder();
                ug = ug.apply(new UTranslate(0.0, header.calculateDimension(stringBounder).getHeight()));
                double x = 0.0;
                double lastX = 0.0;
                double y = 0.0;
                for (TextBlock tb : cols) {
                    Dimension2D dim = tb.calculateDimension(stringBounder);
                    tb.drawU(ug.apply(new UTranslate(x, 0.0)));
                    lastX = x;
                    x += dim.getWidth() + 10.0;
                    y = Math.max(y, dim.getHeight());
                }
                UImage logo = new UImage(PSystemVersion.getPlantumlImage());
                ug.apply(new UTranslate(lastX, y - logo.getHeight())).draw(logo);
            }
        };
    }

    public static List<TextBlock> getCols(List<String> lines, int nbCol, int reserved) throws IOException {
        ArrayList<TextBlock> result = new ArrayList<TextBlock>();
        int maxLine = (lines.size() + (nbCol - 1) + reserved) / nbCol;
        for (int i = 0; i < lines.size(); i += maxLine) {
            List<String> current = lines.subList(i, Math.min(lines.size(), i + maxLine));
            result.add(GraphicStrings.createBlackOnWhite(current));
        }
        return result;
    }

    private List<String> getDonors() throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        TranscoderImpl t = new TranscoderImpl(new CompressionBrotli());
        String s = t.decode(DONORS).replace('*', '.');
        StringTokenizer st = new StringTokenizer(s, "\n");
        while (st.hasMoreTokens()) {
            lines.add(st.nextToken());
        }
        return lines;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Donors)");
    }

    public static PSystemDonors create() {
        return new PSystemDonors();
    }
}

