/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.BlockUmlBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileImageData;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.GeneratedImage;
import net.sourceforge.plantuml.GeneratedImageImpl;
import net.sourceforge.plantuml.ISourceFileReader;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.PSystemError;
import net.sourceforge.plantuml.PSystemUtils;
import net.sourceforge.plantuml.SuggestedFile;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.preproc.FileWithSuffix;

public class SourceFileReader
implements ISourceFileReader {
    private final File file;
    private final File outputDirectory;
    private final BlockUmlBuilder builder;
    private FileFormatOption fileFormatOption;

    public SourceFileReader(File file) throws IOException {
        this(file, file.getAbsoluteFile().getParentFile());
    }

    public SourceFileReader(File file, File outputDirectory, String charset) throws IOException {
        this(Defines.createWithFileName(file), file, outputDirectory, Collections.emptyList(), charset, new FileFormatOption(FileFormat.PNG));
    }

    public SourceFileReader(File file, File outputDirectory) throws IOException {
        this(Defines.createWithFileName(file), file, outputDirectory, Collections.emptyList(), null, new FileFormatOption(FileFormat.PNG));
    }

    public SourceFileReader(File file, File outputDirectory, FileFormatOption fileFormatOption) throws IOException {
        this(Defines.createWithFileName(file), file, outputDirectory, Collections.emptyList(), null, fileFormatOption);
    }

    public SourceFileReader(Defines defines, File file, File outputDirectory, List<String> config, String charset, FileFormatOption fileFormatOption) throws IOException {
        this.file = file;
        this.fileFormatOption = fileFormatOption;
        if (!file.exists()) {
            throw new IllegalArgumentException();
        }
        FileSystem.getInstance().setCurrentDir(file.getAbsoluteFile().getParentFile());
        if (outputDirectory == null) {
            outputDirectory = file.getAbsoluteFile().getParentFile();
        } else if (!outputDirectory.isAbsolute()) {
            outputDirectory = FileSystem.getInstance().getFile(outputDirectory.getPath());
        }
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
        this.outputDirectory = outputDirectory;
        this.builder = new BlockUmlBuilder(config, charset, defines, this.getReader(charset), file.getAbsoluteFile().getParentFile(), file.getAbsolutePath());
    }

    @Override
    public boolean hasError() {
        for (BlockUml b : this.builder.getBlockUmls()) {
            if (!(b.getDiagram() instanceof PSystemError)) continue;
            return true;
        }
        return false;
    }

    private File getDirIfDirectory(String newName) {
        Log.info("Checking=" + newName);
        if (this.endsWithSlashOrAntislash(newName)) {
            Log.info("It ends with / so it looks like a directory");
            newName = newName.substring(0, newName.length() - 1);
            File f = new File(newName);
            Log.info("f=" + f);
            if (!f.isAbsolute()) {
                Log.info("It's relative, so let's change it");
                f = new File(this.outputDirectory, newName);
                Log.info("f=" + f);
            }
            if (!f.exists()) {
                Log.info("It does not exist: let's create it");
                try {
                    f.mkdirs();
                }
                catch (Exception e) {
                    Log.info("Error " + e);
                }
                if (f.exists() && f.isDirectory()) {
                    Log.info("Creation ok");
                    return f;
                }
                Log.info("We cannot create it");
            } else if (!f.isDirectory()) {
                Log.info("It exists, but is not a directory: we ignore it");
                return null;
            }
            return f;
        }
        File f = new File(newName);
        Log.info("f=" + f);
        if (!f.isAbsolute()) {
            Log.info("Relative, so let's change it");
            f = new File(this.outputDirectory, newName);
            Log.info("f=" + f);
        }
        if (f.exists() && f.isDirectory()) {
            Log.info("It's an existing directory");
            return f;
        }
        Log.info("It's not a directory");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GeneratedImage> getGeneratedImages() throws IOException {
        Log.info("Reading file: " + this.file);
        int cpt = 0;
        ArrayList<GeneratedImageImpl> result = new ArrayList<GeneratedImageImpl>();
        for (BlockUml blockUml : this.builder.getBlockUmls()) {
            Diagram system;
            String newName = blockUml.getFileOrDirname();
            SuggestedFile suggested = null;
            if (newName != null) {
                Log.info("name from block=" + newName);
                File dir = this.getDirIfDirectory(newName);
                if (dir == null) {
                    Log.info(newName + " is not taken as a directory");
                    suggested = SuggestedFile.fromOutputFile(new File(this.outputDirectory, newName), this.fileFormatOption.getFileFormat(), 0);
                } else {
                    Log.info("We are going to create files in directory " + dir);
                    suggested = SuggestedFile.fromOutputFile(new File(dir, this.file.getName()), this.fileFormatOption.getFileFormat(), 0);
                }
                Log.info("We are going to put data in " + suggested);
            }
            if (suggested == null) {
                suggested = SuggestedFile.fromOutputFile(new File(this.outputDirectory, this.file.getName()), this.fileFormatOption.getFileFormat(), cpt++);
            }
            suggested.getParentFile().mkdirs();
            try {
                system = blockUml.getDiagram();
            }
            catch (Throwable t) {
                GeneratedImageImpl image = new GeneratedImageImpl(suggested.getFile(0), "Crash Error", blockUml);
                OutputStream os = null;
                try {
                    os = new BufferedOutputStream(new FileOutputStream(suggested.getFile(0)));
                    UmlDiagram.exportDiagramError(os, t, this.fileFormatOption, 42L, null, blockUml.getFlashData(), UmlDiagram.getFailureText2(t, blockUml.getFlashData()));
                }
                finally {
                    if (os != null) {
                        os.close();
                    }
                }
                return Collections.singletonList(image);
            }
            List<FileImageData> exportDiagrams = PSystemUtils.exportDiagrams(system, suggested, this.fileFormatOption);
            if (exportDiagrams.size() > 1) {
                cpt += exportDiagrams.size() - 1;
            }
            OptionFlags.getInstance().logData(this.file, system);
            for (FileImageData fdata : exportDiagrams) {
                String warnOrError;
                String desc = "[" + this.file.getName() + "] " + system.getDescription();
                File f = fdata.getFile();
                if (OptionFlags.getInstance().isWord() && (warnOrError = system.getWarningOrError()) != null) {
                    String name = f.getName().substring(0, f.getName().length() - 4) + ".err";
                    File errorFile = new File(f.getParentFile(), name);
                    PrintStream ps = new PrintStream(new FileOutputStream(errorFile));
                    ps.print(warnOrError);
                    ps.close();
                }
                GeneratedImageImpl generatedImage = new GeneratedImageImpl(f, desc, blockUml);
                result.add(generatedImage);
            }
        }
        Log.info("Number of image(s): " + result.size());
        return Collections.unmodifiableList(result);
    }

    private boolean endsWithSlashOrAntislash(String newName) {
        return newName.endsWith("/") || newName.endsWith("\\");
    }

    @Override
    public List<BlockUml> getBlocks() {
        return this.builder.getBlockUmls();
    }

    private Reader getReader(String charset) throws FileNotFoundException, UnsupportedEncodingException {
        if (charset == null) {
            Log.info("Using default charset");
            return new InputStreamReader(new FileInputStream(this.file));
        }
        Log.info("Using charset " + charset);
        return new InputStreamReader((InputStream)new FileInputStream(this.file), charset);
    }

    @Override
    public final void setFileFormatOption(FileFormatOption fileFormatOption) {
        this.fileFormatOption = fileFormatOption;
    }

    public final Set<FileWithSuffix> getIncludedFiles() {
        return this.builder.getIncludedFiles();
    }
}

