/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.AlignParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.WeldingPoint;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public abstract class AbstractFtile
extends AbstractTextBlock
implements Ftile {
    private final ISkinParam skinParam;
    private FtileGeometry cachedGeometry;

    public AbstractFtile(ISkinParam skinParam) {
        this.skinParam = skinParam;
    }

    @Override
    public final ISkinParam skinParam() {
        if (this.skinParam == null) {
            throw new IllegalStateException();
        }
        return this.skinParam;
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return LinkRendering.none();
    }

    @Override
    public LinkRendering getOutLinkRendering() {
        return LinkRendering.none();
    }

    @Override
    public Collection<Connection> getInnerConnections() {
        return Collections.emptyList();
    }

    @Override
    public UTranslate getTranslateFor(Ftile child, StringBounder stringBounder) {
        throw new UnsupportedOperationException("" + this.getClass());
    }

    @Override
    public final UStroke getThickness() {
        UStroke thickness = this.skinParam.getThickness(LineParam.activityBorder, null);
        if (thickness == null) {
            thickness = new UStroke(1.5);
        }
        return thickness;
    }

    @Override
    public List<WeldingPoint> getWeldingPoints() {
        return Collections.emptyList();
    }

    @Override
    public Collection<Ftile> getMyChildren() {
        throw new UnsupportedOperationException("" + this.getClass());
    }

    @Override
    public HorizontalAlignment arrowHorizontalAlignment() {
        return this.skinParam.getHorizontalAlignment(AlignParam.ARROW_MESSAGE_ALIGN, null);
    }

    @Override
    public final FtileGeometry calculateDimension(StringBounder stringBounder) {
        if (this.cachedGeometry == null) {
            this.cachedGeometry = this.calculateDimensionFtile(stringBounder);
        }
        return this.cachedGeometry;
    }

    protected abstract FtileGeometry calculateDimensionFtile(StringBounder var1);

    @Override
    public final MinMax getMinMax(StringBounder stringBounder) {
        throw new UnsupportedOperationException();
    }
}

