/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.rose.Rose;

public abstract class ParallelFtilesBuilder {
    protected final double barHeight = 6.0;
    private final Rose rose = new Rose();
    private final ISkinParam skinParam;
    private final StringBounder stringBounder;
    private final List<Ftile> list;
    private final Ftile middle;
    private final FtileGeometry middleDimension;
    private final Swimlane swimlane;

    public ParallelFtilesBuilder(ISkinParam skinParam, StringBounder stringBounder, List<Ftile> list, Ftile middle, Swimlane swimlane) {
        this.skinParam = skinParam;
        this.stringBounder = stringBounder;
        this.list = list;
        this.middle = middle;
        this.middleDimension = middle.calculateDimension(this.getStringBounder());
        this.swimlane = swimlane;
    }

    public final Ftile build() {
        Ftile step1 = this.doStep1();
        return this.doStep2(step1);
    }

    protected abstract Ftile doStep1();

    protected abstract Ftile doStep2(Ftile var1);

    protected StringBounder getStringBounder() {
        return this.stringBounder;
    }

    protected Rose getRose() {
        return this.rose;
    }

    protected ISkinParam skinParam() {
        return this.skinParam;
    }

    protected final TextBlock getTextBlock(Display display) {
        if (Display.isNull(display)) {
            return null;
        }
        FontConfiguration fontConfiguration = new FontConfiguration(this.skinParam(), FontParam.ARROW, null);
        return display.create(fontConfiguration, HorizontalAlignment.LEFT, (ISkinSimple)this.skinParam(), CreoleMode.SIMPLE_LINE);
    }

    protected TextBlock getTextBlock(LinkRendering linkRendering) {
        Display display = linkRendering.getDisplay();
        return this.getTextBlock(display);
    }

    protected final List<Ftile> getList() {
        return Collections.unmodifiableList(this.list);
    }

    protected final Ftile getMiddle() {
        return this.middle;
    }

    protected final double getHeightOfMiddle() {
        return this.middleDimension.getHeight();
    }

    protected final Swimlane swimlane() {
        return this.swimlane;
    }
}

