/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.BackSlash;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.CharSequence2Impl;
import net.sourceforge.plantuml.EmbededDiagram;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.LineLocationImpl;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.CreoleParser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.SheetBlock2;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.CircledCharacter;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockSimple;
import net.sourceforge.plantuml.graphic.TextBlockSprited;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.sequencediagram.MessageNumber;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.sprite.Sprite;

public class Display
implements Iterable<CharSequence> {
    private final List<CharSequence> display;
    private final HorizontalAlignment naturalHorizontalAlignment;
    private final boolean isNull;
    private final CreoleMode defaultCreoleMode;
    public static final Display NULL = new Display(null, null, true, CreoleMode.FULL);

    public Display replace(String src, String dest) {
        ArrayList<CharSequence> newDisplay = new ArrayList<CharSequence>();
        for (CharSequence cs : this.display) {
            if (cs.toString().contains(src)) {
                cs = cs.toString().replace(src, dest);
            }
            newDisplay.add(cs);
        }
        return new Display(newDisplay, this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
    }

    public boolean isWhite() {
        return this.display.size() == 0 || this.display.size() == 1 && this.display.get(0).toString().matches("\\s*");
    }

    public static Display empty() {
        return new Display(null, false, CreoleMode.FULL);
    }

    public static Display create(CharSequence ... s) {
        return Display.create(Arrays.asList(s));
    }

    public static Display create(Collection<? extends CharSequence> other) {
        return new Display(other, null, false, CreoleMode.FULL);
    }

    public static Display getWithNewlines(Code s) {
        return Display.getWithNewlines(s.getFullName());
    }

    public static Display getWithNewlines(String s) {
        if (s == null) {
            return NULL;
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        HorizontalAlignment naturalHorizontalAlignment = null;
        boolean rawMode = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            String sub = s.substring(i);
            if (sub.startsWith("<math>") || sub.startsWith("<latex>") || sub.startsWith("[[")) {
                rawMode = true;
            } else if (sub.startsWith("</math>") || sub.startsWith("</latex>") || sub.startsWith("]]")) {
                rawMode = false;
            }
            if (!rawMode && c == '\\' && i < s.length() - 1) {
                char c2 = s.charAt(i + 1);
                ++i;
                if (c2 == 'n' || c2 == 'r' || c2 == 'l') {
                    if (c2 == 'r') {
                        naturalHorizontalAlignment = HorizontalAlignment.RIGHT;
                    } else if (c2 == 'l') {
                        naturalHorizontalAlignment = HorizontalAlignment.LEFT;
                    }
                    result.add(current.toString());
                    current.setLength(0);
                    continue;
                }
                if (c2 == 't') {
                    current.append('\t');
                    continue;
                }
                if (c2 == '\\') {
                    current.append(c2);
                    continue;
                }
                current.append(c);
                current.append(c2);
                continue;
            }
            if (c == BackSlash.hiddenNewLine()) {
                result.add(current.toString());
                current.setLength(0);
                continue;
            }
            current.append(c);
        }
        result.add(current.toString());
        return new Display(result, naturalHorizontalAlignment, false, CreoleMode.FULL);
    }

    private Display(Display other, CreoleMode mode) {
        this(other.naturalHorizontalAlignment, other.isNull, mode);
        this.display.addAll(other.display);
    }

    private Display(HorizontalAlignment naturalHorizontalAlignment, boolean isNull, CreoleMode defaultCreoleMode) {
        this.defaultCreoleMode = defaultCreoleMode;
        this.isNull = isNull;
        this.display = isNull ? null : new ArrayList();
        this.naturalHorizontalAlignment = isNull ? null : naturalHorizontalAlignment;
    }

    private Display(Collection<? extends CharSequence> other, HorizontalAlignment naturalHorizontalAlignment, boolean isNull, CreoleMode defaultCreoleMode) {
        this(naturalHorizontalAlignment, isNull, defaultCreoleMode);
        if (!isNull) {
            this.display.addAll(Display.manageEmbededDiagrams2(other));
        }
    }

    private static List<CharSequence> manageEmbededDiagrams2(Collection<? extends CharSequence> strings) {
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        Iterator<? extends CharSequence> it = strings.iterator();
        while (it.hasNext()) {
            CharSequence s = it.next();
            if (s != null && StringUtils.trin(s.toString()).equals("{{")) {
                CharSequence s2;
                ArrayList<CharSequence> other = new ArrayList<CharSequence>();
                other.add("@startuml");
                while (it.hasNext() && ((s2 = it.next()) == null || !StringUtils.trin(s2.toString()).equals("}}"))) {
                    other.add(s2);
                }
                other.add("@enduml");
                s = new EmbededDiagram(Display.create(other));
            }
            result.add(s);
        }
        return result;
    }

    public Display manageGuillemet() {
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        for (CharSequence line : this.display) {
            String withGuillement = StringUtils.manageGuillemet(line.toString());
            if (withGuillement.equals(line.toString())) {
                result.add(line);
                continue;
            }
            result.add(withGuillement);
        }
        return new Display(result, this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
    }

    public Display withPage(int page, int lastpage) {
        if (this.display == null) {
            return this;
        }
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        for (CharSequence line : this.display) {
            line = line.toString().replace("%page%", "" + page);
            line = line.toString().replace("%lastpage%", "" + lastpage);
            result.add(line);
        }
        return new Display(result, this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
    }

    public Display underlined() {
        ArrayList<String> result = new ArrayList<String>();
        for (CharSequence line : this.display) {
            result.add("<u>" + line);
        }
        return new Display(result, this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
    }

    public Display withCreoleMode(CreoleMode mode) {
        if (this.isNull) {
            throw new IllegalArgumentException();
        }
        return new Display(this, mode);
    }

    public String toString() {
        if (this.isNull) {
            return "NULL";
        }
        return this.display.toString();
    }

    public int hashCode() {
        return this.display.hashCode();
    }

    public boolean equals(Object other) {
        return this.display.equals(((Display)other).display);
    }

    public Display addAll(Display other) {
        Display result = new Display(this, this.defaultCreoleMode);
        result.display.addAll(other.display);
        return result;
    }

    public Display addFirst(CharSequence s) {
        Display result = new Display(this, this.defaultCreoleMode);
        result.display.add(0, s);
        return result;
    }

    public Display add(CharSequence s) {
        Display result = new Display(this, this.defaultCreoleMode);
        result.display.add(s);
        return result;
    }

    public Display addGeneric(CharSequence s) {
        Display result = new Display(this, this.defaultCreoleMode);
        int size = this.display.size();
        if (size == 0) {
            result.display.add("<" + s + ">");
        } else {
            result.display.set(size - 1, this.display.get(size - 1) + "<" + s + ">");
        }
        return result;
    }

    public int size() {
        if (this.isNull) {
            return 0;
        }
        return this.display.size();
    }

    public CharSequence get(int i) {
        return this.display.get(i);
    }

    @Override
    public Iterator<CharSequence> iterator() {
        return Collections.unmodifiableList(this.display).iterator();
    }

    public Display subList(int i, int size) {
        return new Display(this.display.subList(i, size), this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
    }

    public List<? extends CharSequence> as() {
        return Collections.unmodifiableList(this.display);
    }

    public List<CharSequence2> as2() {
        ArrayList<CharSequence2Impl> result = new ArrayList<CharSequence2Impl>();
        LineLocationImpl location = new LineLocationImpl("inner", null);
        for (CharSequence cs : this.display) {
            location = location.oneLineRead();
            result.add(new CharSequence2Impl(cs, location));
        }
        return Collections.unmodifiableList(result);
    }

    public boolean hasUrl() {
        UrlBuilder urlBuilder = new UrlBuilder(null, UrlBuilder.ModeUrl.ANYWHERE);
        for (CharSequence s : this) {
            if (urlBuilder.getUrl(s.toString()) == null) continue;
            return true;
        }
        return false;
    }

    public HorizontalAlignment getNaturalHorizontalAlignment() {
        return this.naturalHorizontalAlignment;
    }

    public List<Display> splitMultiline(Pattern2 separator) {
        ArrayList<Display> result = new ArrayList<Display>();
        Display pending = new Display(this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
        result.add(pending);
        for (CharSequence line : this.display) {
            Matcher2 m = separator.matcher(line);
            if (m.find()) {
                CharSequence s1 = line.subSequence(0, m.start());
                pending.display.add(s1);
                CharSequence s2 = line.subSequence(m.end(), line.length());
                pending = new Display(this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
                result.add(pending);
                pending.display.add(s2);
                continue;
            }
            pending.display.add(line);
        }
        return Collections.unmodifiableList(result);
    }

    public static boolean isNull(Display display) {
        return display == null || display.isNull;
    }

    public TextBlock create(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple spriteContainer) {
        return this.create(fontConfiguration, horizontalAlignment, spriteContainer, CreoleMode.FULL);
    }

    public TextBlock createWithNiceCreoleMode(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple spriteContainer) {
        return this.create(fontConfiguration, horizontalAlignment, spriteContainer, this.defaultCreoleMode);
    }

    public TextBlock create(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple spriteContainer, CreoleMode modeSimpleLine) {
        return this.create(fontConfiguration, horizontalAlignment, spriteContainer, LineBreakStrategy.NONE, modeSimpleLine, null, null);
    }

    public TextBlock create(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple spriteContainer, CreoleMode modeSimpleLine, LineBreakStrategy maxMessageSize) {
        return this.create(fontConfiguration, horizontalAlignment, spriteContainer, maxMessageSize, modeSimpleLine, null, null);
    }

    public TextBlock create(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple spriteContainer, LineBreakStrategy maxMessageSize) {
        return this.create(fontConfiguration, horizontalAlignment, spriteContainer, maxMessageSize, this.defaultCreoleMode, null, null);
    }

    public TextBlock create(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple spriteContainer, LineBreakStrategy maxMessageSize, CreoleMode modeSimpleLine, UFont fontForStereotype, HtmlColor htmlColorForStereotype) {
        if (maxMessageSize == null) {
            throw new IllegalArgumentException();
        }
        if (this.getNaturalHorizontalAlignment() != null) {
            horizontalAlignment = this.getNaturalHorizontalAlignment();
        }
        if (this.size() > 0) {
            if (this.get(0) instanceof Stereotype) {
                return this.createStereotype(fontConfiguration, horizontalAlignment, spriteContainer, 0, fontForStereotype, htmlColorForStereotype);
            }
            if (this.get(this.size() - 1) instanceof Stereotype) {
                return this.createStereotype(fontConfiguration, horizontalAlignment, spriteContainer, this.size() - 1, fontForStereotype, htmlColorForStereotype);
            }
            if (this.get(0) instanceof MessageNumber) {
                return this.createMessageNumber(fontConfiguration, horizontalAlignment, spriteContainer, maxMessageSize);
            }
        }
        return this.getCreole(fontConfiguration, horizontalAlignment, spriteContainer, maxMessageSize, modeSimpleLine);
    }

    private TextBlock getCreole(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple spriteContainer, LineBreakStrategy maxMessageSize, CreoleMode modeSimpleLine) {
        Sheet sheet = new CreoleParser(fontConfiguration, horizontalAlignment, spriteContainer, modeSimpleLine).createSheet(this);
        SheetBlock1 sheetBlock1 = new SheetBlock1(sheet, maxMessageSize, spriteContainer == null ? 0.0 : spriteContainer.getPadding());
        return new SheetBlock2(sheetBlock1, sheetBlock1, new UStroke(1.5));
    }

    private TextBlock createMessageNumber(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple spriteContainer, LineBreakStrategy maxMessageSize) {
        TextBlock tb1 = this.subList(0, 1).getCreole(fontConfiguration, horizontalAlignment, spriteContainer, maxMessageSize, CreoleMode.FULL);
        tb1 = TextBlockUtils.withMargin(tb1, 0.0, 4.0, 0.0, 0.0);
        TextBlock tb2 = this.subList(1, this.size()).getCreole(fontConfiguration, horizontalAlignment, spriteContainer, maxMessageSize, CreoleMode.FULL);
        return TextBlockUtils.mergeLR(tb1, tb2, VerticalAlignment.CENTER);
    }

    private TextBlock createStereotype(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, SpriteContainer spriteContainer, int position, UFont fontForStereotype, HtmlColor htmlColorForStereotype) {
        Sprite tmp;
        Stereotype stereotype = (Stereotype)this.get(position);
        TextBlock circledCharacter = null;
        if (stereotype.isSpotted()) {
            circledCharacter = new CircledCharacter(stereotype.getCharacter(), stereotype.getRadius(), stereotype.getCircledFont(), stereotype.getHtmlColor(), null, fontConfiguration.getColor());
        } else if (stereotype.getSprite() != null && (tmp = spriteContainer.getSprite(stereotype.getSprite())) != null) {
            circledCharacter = tmp.asTextBlock(stereotype.getHtmlColor(), 1.0);
        }
        if (circledCharacter != null) {
            if (stereotype.getLabel(false) == null) {
                return new TextBlockSprited(circledCharacter, this.subList(1, this.size()), fontConfiguration, horizontalAlignment, spriteContainer);
            }
            return new TextBlockSprited(circledCharacter, this, fontConfiguration, horizontalAlignment, spriteContainer);
        }
        return new TextBlockSimple(this, fontConfiguration, horizontalAlignment, spriteContainer, 0.0, fontForStereotype, htmlColorForStereotype);
    }
}

