/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.project3.Complement;
import net.sourceforge.plantuml.project3.ComplementPattern;
import net.sourceforge.plantuml.project3.GanttDiagram;
import net.sourceforge.plantuml.project3.Subject;
import net.sourceforge.plantuml.project3.SubjectPattern;
import net.sourceforge.plantuml.project3.Verb;
import net.sourceforge.plantuml.project3.VerbPattern;

public class NaturalCommandAndAnd
extends SingleLineCommand2<GanttDiagram> {
    private final SubjectPattern subjectPattern;
    private final VerbPattern verbPattern1;
    private final ComplementPattern complementPattern1;
    private final VerbPattern verbPattern2;
    private final ComplementPattern complementPattern2;
    private final VerbPattern verbPattern3;
    private final ComplementPattern complementPattern3;

    private NaturalCommandAndAnd(RegexConcat pattern, SubjectPattern subject, VerbPattern verb1, ComplementPattern complement1, VerbPattern verb2, ComplementPattern complement2, VerbPattern verb3, ComplementPattern complement3) {
        super(pattern);
        this.subjectPattern = subject;
        this.verbPattern1 = verb1;
        this.complementPattern1 = complement1;
        this.verbPattern2 = verb2;
        this.complementPattern2 = complement2;
        this.verbPattern3 = verb3;
        this.complementPattern3 = complement3;
    }

    public String toString() {
        return this.subjectPattern.toString() + " " + this.verbPattern1.toString() + " " + this.complementPattern1.toString() + " and " + this.verbPattern2.toString() + " " + this.complementPattern2.toString() + " and " + this.verbPattern3.toString() + " " + this.complementPattern3.toString();
    }

    @Override
    protected CommandExecutionResult executeArg(GanttDiagram system, RegexResult arg) {
        Complement complement2;
        Complement complement1;
        Subject subject = this.subjectPattern.getSubject(system, arg);
        Verb verb1 = this.verbPattern1.getVerb(system, arg);
        CommandExecutionResult result1 = verb1.execute(subject, complement1 = this.complementPattern1.getComplement(system, arg, "1").get());
        if (!result1.isOk()) {
            return result1;
        }
        Verb verb2 = this.verbPattern2.getVerb(system, arg);
        CommandExecutionResult result2 = verb2.execute(subject, complement2 = this.complementPattern2.getComplement(system, arg, "2").get());
        if (!result2.isOk()) {
            return result2;
        }
        Verb verb3 = this.verbPattern3.getVerb(system, arg);
        Complement complement3 = this.complementPattern3.getComplement(system, arg, "3").get();
        return verb3.execute(subject, complement3);
    }

    public static Command create(SubjectPattern subject, VerbPattern verb1, ComplementPattern complement1, VerbPattern verb2, ComplementPattern complement2, VerbPattern verb3, ComplementPattern complement3) {
        RegexConcat pattern = new RegexConcat(new RegexLeaf("^"), subject.toRegex(), new RegexLeaf("[%s]+"), verb1.toRegex(), new RegexLeaf("[%s]+"), complement1.toRegex("1"), new RegexLeaf("[%s]+"), new RegexLeaf("and"), new RegexLeaf("[%s]+"), verb2.toRegex(), new RegexLeaf("[%s]+"), complement2.toRegex("2"), new RegexLeaf("[%s]+"), new RegexLeaf("and"), new RegexLeaf("[%s]+"), verb3.toRegex(), new RegexLeaf("[%s]+"), complement3.toRegex("3"), new RegexLeaf("$"));
        return new NaturalCommandAndAnd(pattern, subject, verb1, complement1, verb2, complement2, verb3, complement3);
    }
}

