/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import java.text.DecimalFormat;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

public class CommandAutonumberResume
extends SingleLineCommand2<SequenceDiagram> {
    public CommandAutonumberResume() {
        super(CommandAutonumberResume.getConcat());
    }

    private static RegexConcat getConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("autonumber"), new RegexLeaf("[%s]+"), new RegexLeaf("resume"), new RegexLeaf("[%s]*"), new RegexLeaf("INC", "(?:[%s]+(\\d+))?"), new RegexLeaf("DF", "(?:[%s]+[%g]([^%g]+)[%g])?"), new RegexLeaf("$"));
    }

    @Override
    protected CommandExecutionResult executeArg(SequenceDiagram diagram, RegexResult arg) {
        String inc;
        String df = arg.get("DF", 0);
        DecimalFormat decimalFormat = null;
        if (df != null) {
            try {
                decimalFormat = new DecimalFormat(df);
            }
            catch (IllegalArgumentException e) {
                return CommandExecutionResult.error("Error in pattern : " + df);
            }
        }
        if ((inc = arg.get("INC", 0)) == null) {
            diagram.getAutoNumber().resume(decimalFormat);
        } else {
            diagram.getAutoNumber().resume(Integer.parseInt(inc), decimalFormat);
        }
        return CommandExecutionResult.ok();
    }
}

