/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.bluemodern;

import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDirection;
import net.sourceforge.plantuml.skin.ArrowPart;
import net.sourceforge.plantuml.skin.bluemodern.AbstractComponentBlueModernArrow;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ComponentBlueModernArrow
extends AbstractComponentBlueModernArrow {
    public ComponentBlueModernArrow(HtmlColor foregroundColor, boolean useUnderlineForHyperlink, FontConfiguration font, Display stringsToDisplay, ArrowConfiguration arrowConfiguration, ISkinSimple spriteContainer) {
        super(foregroundColor, font, stringsToDisplay, arrowConfiguration, spriteContainer);
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        if (this.getArrowConfiguration().isHidden()) {
            return;
        }
        Dimension2D dimensionToUse = area.getDimensionToUse();
        StringBounder stringBounder = ug.getStringBounder();
        int textHeight = (int)this.getTextHeight(stringBounder);
        ug = ug.apply(new UChangeColor(this.getForegroundColor()));
        ug = ug.apply(new UChangeBackColor(this.getForegroundColor()));
        int x2 = (int)dimensionToUse.getWidth();
        ug = this.getArrowConfiguration().isDotted() ? ArrowConfiguration.stroke(ug, 5.0, 2.0, 1.0) : ug.apply(new UStroke(2.0));
        ug.apply(new UTranslate(2.0, textHeight)).draw(new ULine(x2 - 4, 0.0));
        ug = ug.apply(new UStroke());
        int direction = this.getDirection();
        UPolygon polygon = new UPolygon();
        if (this.getArrowConfiguration().isAsync()) {
            ug = ug.apply(new UStroke(1.5));
            if (direction == 1) {
                if (this.getArrowConfiguration().getPart() != ArrowPart.BOTTOM_PART) {
                    ug.apply(new UTranslate(x2 - this.getArrowDeltaX2(), textHeight - this.getArrowDeltaY2())).draw(new ULine(this.getArrowDeltaX2(), this.getArrowDeltaY2()));
                }
                if (this.getArrowConfiguration().getPart() != ArrowPart.TOP_PART) {
                    ug.apply(new UTranslate(x2 - this.getArrowDeltaX2(), textHeight + this.getArrowDeltaY2())).draw(new ULine(this.getArrowDeltaX2(), -this.getArrowDeltaY2()));
                }
            } else {
                if (this.getArrowConfiguration().getPart() != ArrowPart.BOTTOM_PART) {
                    ug.apply(new UTranslate(this.getArrowDeltaX2(), textHeight - this.getArrowDeltaY2())).draw(new ULine(-this.getArrowDeltaX2(), this.getArrowDeltaY2()));
                }
                if (this.getArrowConfiguration().getPart() != ArrowPart.TOP_PART) {
                    ug.apply(new UTranslate(this.getArrowDeltaX2(), textHeight + this.getArrowDeltaY2())).draw(new ULine(-this.getArrowDeltaX2(), -this.getArrowDeltaY2()));
                }
            }
            ug = ug.apply(new UStroke());
        } else if (direction == 1) {
            this.createPolygonNormal(textHeight, x2, polygon);
        } else {
            this.createPolygonReverse(textHeight, polygon);
        }
        ug.draw(polygon);
        this.getTextBlock().drawU(ug.apply(new UTranslate(this.getMarginX1(), 0.0)));
    }

    private void createPolygonReverse(int textHeight, UPolygon polygon) {
        if (this.getArrowConfiguration().getPart() == ArrowPart.TOP_PART) {
            polygon.addPoint(this.getArrowDeltaX(), textHeight - this.getArrowDeltaY());
            polygon.addPoint(0.0, textHeight);
            polygon.addPoint(this.getArrowDeltaX(), textHeight);
        } else if (this.getArrowConfiguration().getPart() == ArrowPart.BOTTOM_PART) {
            polygon.addPoint(this.getArrowDeltaX(), textHeight);
            polygon.addPoint(0.0, textHeight);
            polygon.addPoint(this.getArrowDeltaX(), textHeight + this.getArrowDeltaY());
        } else {
            polygon.addPoint(this.getArrowDeltaX(), textHeight - this.getArrowDeltaY());
            polygon.addPoint(0.0, textHeight);
            polygon.addPoint(this.getArrowDeltaX(), textHeight + this.getArrowDeltaY());
        }
    }

    private void createPolygonNormal(int textHeight, int x2, UPolygon polygon) {
        if (this.getArrowConfiguration().getPart() == ArrowPart.TOP_PART) {
            polygon.addPoint(x2 - this.getArrowDeltaX(), textHeight - this.getArrowDeltaY());
            polygon.addPoint(x2, textHeight);
            polygon.addPoint(x2 - this.getArrowDeltaX(), textHeight);
        } else if (this.getArrowConfiguration().getPart() == ArrowPart.BOTTOM_PART) {
            polygon.addPoint(x2 - this.getArrowDeltaX(), textHeight);
            polygon.addPoint(x2, textHeight);
            polygon.addPoint(x2 - this.getArrowDeltaX(), textHeight + this.getArrowDeltaY());
        } else {
            polygon.addPoint(x2 - this.getArrowDeltaX(), textHeight - this.getArrowDeltaY());
            polygon.addPoint(x2, textHeight);
            polygon.addPoint(x2 - this.getArrowDeltaX(), textHeight + this.getArrowDeltaY());
        }
    }

    protected int getDirection(Graphics2D g2d) {
        return this.getDirection();
    }

    protected int getDirection() {
        if (this.getArrowConfiguration().getArrowDirection() == ArrowDirection.LEFT_TO_RIGHT_NORMAL) {
            return 1;
        }
        if (this.getArrowConfiguration().getArrowDirection() == ArrowDirection.RIGHT_TO_LEFT_REVERSE) {
            return -1;
        }
        throw new IllegalStateException();
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + (double)this.getArrowDeltaY() + 2.0 * this.getPaddingY();
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder);
    }

    @Override
    public Point2D getStartPoint(StringBounder stringBounder, Dimension2D dimensionToUse) {
        int textHeight = (int)this.getTextHeight(stringBounder);
        if (this.getArrowConfiguration().getArrowDirection() == ArrowDirection.LEFT_TO_RIGHT_NORMAL) {
            return new Point2D.Double(this.getPaddingX(), (double)textHeight + this.getPaddingY());
        }
        return new Point2D.Double(dimensionToUse.getWidth() + this.getPaddingX(), (double)textHeight + this.getPaddingY());
    }

    @Override
    public Point2D getEndPoint(StringBounder stringBounder, Dimension2D dimensionToUse) {
        int textHeight = (int)this.getTextHeight(stringBounder);
        if (this.getArrowConfiguration().getArrowDirection() == ArrowDirection.LEFT_TO_RIGHT_NORMAL) {
            return new Point2D.Double(dimensionToUse.getWidth() + this.getPaddingX(), (double)textHeight + this.getPaddingY());
        }
        return new Point2D.Double(this.getPaddingX(), (double)textHeight + this.getPaddingY());
    }
}

