/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

public class Slot
implements Comparable<Slot> {
    private final double start;
    private final double end;

    public Slot(double start, double end) {
        if (start >= end) {
            throw new IllegalArgumentException();
        }
        this.start = start;
        this.end = end;
    }

    public String toString() {
        return "(" + this.start + "," + this.end + ")";
    }

    public double getStart() {
        return this.start;
    }

    public double getEnd() {
        return this.end;
    }

    public double size() {
        return this.end - this.start;
    }

    public boolean contains(double v) {
        return v >= this.start && v <= this.end;
    }

    public boolean intersect(Slot other) {
        return this.contains(other.start) || this.contains(other.end) || other.contains(this.start) || other.contains(this.end);
    }

    public Slot merge(Slot other) {
        return new Slot(Math.min(this.start, other.start), Math.max(this.end, other.end));
    }

    public Slot intersect(double otherStart, double otherEnd) {
        if (otherStart >= this.end) {
            return null;
        }
        if (otherEnd <= this.start) {
            return null;
        }
        return new Slot(Math.max(this.start, otherStart), Math.min(this.end, otherEnd));
    }

    @Override
    public int compareTo(Slot other) {
        if (this.start < other.start) {
            return -1;
        }
        if (this.start > other.start) {
            return 1;
        }
        return 0;
    }
}

