/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import net.sourceforge.plantuml.Annotated;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.EntityImageLegend;
import net.sourceforge.plantuml.cucadiagram.DisplayPositionned;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.svek.DecorateEntityImage;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;

public class AnnotatedWorker {
    private final Annotated annotated;
    private final ISkinParam skinParam;

    public AnnotatedWorker(Annotated annotated, ISkinParam skinParam) {
        this.annotated = annotated;
        this.skinParam = skinParam;
    }

    public TextBlockBackcolored addAdd(TextBlock result) {
        result = this.addLegend(result);
        result = this.addTitle(result);
        result = this.addCaption(result);
        result = this.addHeaderAndFooter(result);
        return (TextBlockBackcolored)result;
    }

    private TextBlock addLegend(TextBlock original) {
        DisplayPositionned legend = this.annotated.getLegend();
        if (DisplayPositionned.isNull(legend)) {
            return original;
        }
        TextBlock text = EntityImageLegend.create(legend.getDisplay(), this.getSkinParam());
        return DecorateEntityImage.add(original, text, legend.getHorizontalAlignment(), legend.getVerticalAlignment());
    }

    private ISkinParam getSkinParam() {
        return this.skinParam;
    }

    private TextBlock addCaption(TextBlock original) {
        DisplayPositionned caption = this.annotated.getCaption();
        if (DisplayPositionned.isNull(caption)) {
            return original;
        }
        TextBlock text = this.getCaption();
        return DecorateEntityImage.addBottom(original, text, HorizontalAlignment.CENTER);
    }

    public TextBlock getCaption() {
        DisplayPositionned caption = this.annotated.getCaption();
        if (DisplayPositionned.isNull(caption)) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        return caption.getDisplay().create(new FontConfiguration(this.getSkinParam(), FontParam.CAPTION, null), HorizontalAlignment.CENTER, this.getSkinParam());
    }

    private TextBlock addTitle(TextBlock original) {
        DisplayPositionned title = this.annotated.getTitle();
        if (DisplayPositionned.isNull(title)) {
            return original;
        }
        ISkinParam skinParam = this.getSkinParam();
        FontConfiguration fontConfiguration = new FontConfiguration(skinParam, FontParam.TITLE, null);
        TextBlock block2 = TextBlockUtils.title(fontConfiguration, title.getDisplay(), skinParam);
        return DecorateEntityImage.addTop(original, block2, HorizontalAlignment.CENTER);
    }

    private TextBlock addHeaderAndFooter(TextBlock original) {
        DisplayPositionned footer = this.annotated.getFooter();
        DisplayPositionned header = this.annotated.getHeader();
        if (DisplayPositionned.isNull(footer) && DisplayPositionned.isNull(header)) {
            return original;
        }
        TextBlock textFooter = null;
        if (!DisplayPositionned.isNull(footer)) {
            textFooter = footer.getDisplay().create(new FontConfiguration(this.getSkinParam(), FontParam.FOOTER, null), footer.getHorizontalAlignment(), this.getSkinParam());
        }
        TextBlock textHeader = null;
        if (!DisplayPositionned.isNull(header)) {
            textHeader = header.getDisplay().create(new FontConfiguration(this.getSkinParam(), FontParam.HEADER, null), header.getHorizontalAlignment(), this.getSkinParam());
        }
        return DecorateEntityImage.addTopAndBottom(original, textHeader, header.getHorizontalAlignment(), textFooter, footer.getHorizontalAlignment());
    }
}

