/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import javax.imageio.ImageIO;
import javax.script.ScriptException;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.Annotated;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.PSystemUtils;
import net.sourceforge.plantuml.Pragma;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.SuggestedFile;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.anim.Animation;
import net.sourceforge.plantuml.anim.AnimationDecoder;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.cucadiagram.DisplayPositionned;
import net.sourceforge.plantuml.cucadiagram.UnparsableGraphvizException;
import net.sourceforge.plantuml.flashcode.FlashCodeFactory;
import net.sourceforge.plantuml.flashcode.FlashCodeUtils;
import net.sourceforge.plantuml.fun.IconLoader;
import net.sourceforge.plantuml.graphic.GraphicPosition;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.mjpeg.MJPEGGenerator;
import net.sourceforge.plantuml.pdf.PdfConverter;
import net.sourceforge.plantuml.svek.EmptySvgException;
import net.sourceforge.plantuml.svek.GraphvizCrash;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.sprite.Sprite;
import net.sourceforge.plantuml.version.Version;

public abstract class UmlDiagram
extends AbstractPSystem
implements Diagram,
Annotated {
    private boolean rotation;
    private boolean hideUnlinkedData;
    private int minwidth = Integer.MAX_VALUE;
    private DisplayPositionned title = DisplayPositionned.none(HorizontalAlignment.CENTER, VerticalAlignment.TOP);
    private DisplayPositionned caption = DisplayPositionned.none(HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM);
    private DisplayPositionned header = DisplayPositionned.none(HorizontalAlignment.RIGHT, VerticalAlignment.TOP);
    private DisplayPositionned footer = DisplayPositionned.none(HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM);
    private DisplayPositionned legend = DisplayPositionned.none(HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM);
    private final Pragma pragma = new Pragma();
    private Animation animation;
    private final SkinParam skinParam = SkinParam.create(this.getUmlDiagramType());
    private Dimension2D lastInfo;
    private boolean useJDot;

    public final void setTitle(DisplayPositionned title) {
        if (DisplayPositionned.isNull(title) || title.getDisplay().isWhite()) {
            return;
        }
        this.title = title;
    }

    public final void setCaption(DisplayPositionned caption) {
        this.caption = caption;
    }

    @Override
    public final DisplayPositionned getCaption() {
        return this.caption;
    }

    @Override
    public final DisplayPositionned getTitle() {
        return this.title;
    }

    public final int getMinwidth() {
        return this.minwidth;
    }

    public final void setMinwidth(int minwidth) {
        this.minwidth = minwidth;
    }

    public final boolean isRotation() {
        return this.rotation;
    }

    public final void setRotation(boolean rotation) {
        this.rotation = rotation;
    }

    public final ISkinParam getSkinParam() {
        return this.skinParam;
    }

    public void setParam(String key, String value) {
        this.skinParam.setParam(StringUtils.goLowerCase(key), value);
    }

    @Override
    public final DisplayPositionned getHeader() {
        return this.header;
    }

    public final void setHeader(DisplayPositionned header) {
        this.header = header;
    }

    @Override
    public final DisplayPositionned getFooter() {
        return this.footer;
    }

    public final void setFooter(DisplayPositionned footer) {
        this.footer = footer;
    }

    public final DisplayPositionned getFooterOrHeaderTeoz(FontParam param) {
        if (param == FontParam.FOOTER) {
            return this.getFooter();
        }
        if (param == FontParam.HEADER) {
            return this.getHeader();
        }
        throw new IllegalArgumentException();
    }

    public abstract UmlDiagramType getUmlDiagramType();

    public Pragma getPragma() {
        return this.pragma;
    }

    public final void setAnimation(Iterable<CharSequence> animationData) {
        try {
            AnimationDecoder animationDecoder = new AnimationDecoder(animationData);
            this.animation = Animation.create(animationDecoder.decode());
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
    }

    public final Animation getAnimation() {
        return this.animation;
    }

    public final double getDpiFactor(FileFormatOption fileFormatOption) {
        if (this.getSkinParam().getDpi() == 96) {
            return 1.0;
        }
        return (double)this.getSkinParam().getDpi() / 96.0;
    }

    public final int getDpi(FileFormatOption fileFormatOption) {
        return this.getSkinParam().getDpi();
    }

    public final boolean isHideUnlinkedData() {
        return this.hideUnlinkedData;
    }

    public final void setHideUnlinkedData(boolean hideUnlinkedData) {
        this.hideUnlinkedData = hideUnlinkedData;
    }

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int index, FileFormatOption fileFormatOption, long seed) throws IOException {
        HtmlColor hover = this.getSkinParam().getHoverPathColor();
        fileFormatOption = fileFormatOption.withSvgLinkTarget(this.getSkinParam().getSvgLinkTarget());
        fileFormatOption = fileFormatOption.withTikzFontDistortion(this.getSkinParam().getTikzFontDistortion());
        if (hover != null) {
            fileFormatOption = fileFormatOption.withHoverColor(StringUtils.getAsHtml(this.getSkinParam().getColorMapper().getMappedColor(hover)));
        }
        if (fileFormatOption.getFileFormat() == FileFormat.PDF) {
            return this.exportDiagramInternalPdf(os, index);
        }
        try {
            ImageData imageData = this.exportDiagramInternal(os, index, fileFormatOption);
            this.lastInfo = new Dimension2DDouble(imageData.getWidth(), imageData.getHeight());
            return imageData;
        }
        catch (UnparsableGraphvizException e) {
            e.printStackTrace();
            this.exportDiagramError(os, e.getCause(), fileFormatOption, seed, e.getGraphvizVersion());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.exportDiagramError(os, e, fileFormatOption, seed, null);
        }
        return ImageDataSimple.error();
    }

    private void exportDiagramError(OutputStream os, Throwable exception, FileFormatOption fileFormat, long seed, String graphvizVersion) throws IOException {
        UmlDiagram.exportDiagramError(os, exception, fileFormat, seed, this.getMetadata(), this.getFlashData(), UmlDiagram.getFailureText1(exception, graphvizVersion, this.getFlashData()));
    }

    public static void exportDiagramError(OutputStream os, Throwable exception, FileFormatOption fileFormat, long seed, String metadata, String flash, List<String> strings) throws IOException {
        if (fileFormat.getFileFormat() == FileFormat.ATXT || fileFormat.getFileFormat() == FileFormat.UTXT) {
            UmlDiagram.exportDiagramErrorText(os, exception, strings);
            return;
        }
        strings.addAll(CommandExecutionResult.getStackTrace(exception));
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, HtmlColorUtils.WHITE, metadata, null, 0.0, 0.0, null, false);
        FlashCodeUtils utils = FlashCodeFactory.getFlashCodeUtils();
        final BufferedImage im = utils.exportFlashcode(flash);
        if (im != null) {
            GraphvizCrash.addDecodeHint(strings);
        }
        final TextBlockBackcolored graphicStrings = GraphicStrings.createBlackOnWhite(strings, IconLoader.getRandom(), GraphicPosition.BACKGROUND_CORNER_TOP_RIGHT);
        if (im == null) {
            imageBuilder.setUDrawable(graphicStrings);
        } else {
            imageBuilder.setUDrawable(new UDrawable(){

                @Override
                public void drawU(UGraphic ug) {
                    graphicStrings.drawU(ug);
                    double height = graphicStrings.calculateDimension(ug.getStringBounder()).getHeight();
                    ug = ug.apply(new UTranslate(0.0, height));
                    ug.draw(new UImage(im));
                }
            });
        }
        imageBuilder.writeImageTOBEMOVED(fileFormat, seed, os);
    }

    private static void exportDiagramErrorText(OutputStream os, Throwable exception, List<String> strings) {
        PrintWriter pw = new PrintWriter(os);
        exception.printStackTrace(pw);
        pw.println();
        pw.println();
        for (String s : strings) {
            s = s.replaceAll("\\</?\\w+?\\>", "");
            pw.println(s);
        }
        pw.flush();
    }

    public String getFlashData() {
        UmlSource source = this.getSource();
        if (source == null) {
            return "";
        }
        return source.getPlainString();
    }

    private static List<String> getFailureText1(Throwable exception, String graphvizVersion, String textDiagram) {
        List<String> strings = GraphvizCrash.anErrorHasOccured(exception, textDiagram);
        strings.add("PlantUML (" + Version.versionString() + ") cannot parse result from dot/GraphViz.");
        if (exception instanceof EmptySvgException) {
            strings.add("Because dot/GraphViz returns an empty string.");
        }
        GraphvizCrash.checkOldVersionWarning(strings);
        if (graphvizVersion != null) {
            strings.add(" ");
            strings.add("GraphViz version used : " + graphvizVersion);
        }
        GraphvizCrash.pleaseGoTo(strings);
        GraphvizCrash.addProperties(strings);
        strings.add(" ");
        GraphvizCrash.thisMayBeCaused(strings);
        strings.add(" ");
        GraphvizCrash.youShouldSendThisDiagram(strings);
        strings.add(" ");
        return strings;
    }

    public static List<String> getFailureText2(Throwable exception, String textDiagram) {
        List<String> strings = GraphvizCrash.anErrorHasOccured(exception, textDiagram);
        strings.add("PlantUML (" + Version.versionString() + ") has crashed.");
        GraphvizCrash.checkOldVersionWarning(strings);
        strings.add(" ");
        GraphvizCrash.youShouldSendThisDiagram(strings);
        strings.add(" ");
        return strings;
    }

    private void exportDiagramInternalMjpeg(OutputStream os) throws IOException {
        File f = new File("c:/test.avi");
        int nb = 150;
        double framerate = 30.0;
        MJPEGGenerator m = new MJPEGGenerator(f, 640, 480, 30.0, 150);
        for (int i = 0; i < 150; ++i) {
            AffineTransform at = new AffineTransform();
            double coef = (double)(149 - i) * 1.0 / 150.0;
            at.setToShear(coef, coef);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.close();
            BufferedImage im = ImageIO.read(new ByteArrayInputStream(baos.toByteArray()));
            m.addImage(im);
        }
        m.finishAVI();
    }

    private ImageData exportDiagramInternalPdf(OutputStream os, int index) throws IOException {
        File svg = FileUtils.createTempFile("pdf", ".svf");
        File pdfFile = FileUtils.createTempFile("pdf", ".pdf");
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(svg));
        ImageData result = this.exportDiagram(fos, index, new FileFormatOption(FileFormat.SVG));
        ((OutputStream)fos).close();
        PdfConverter.convert(svg, pdfFile);
        FileUtils.copyToStream(pdfFile, os);
        return result;
    }

    protected abstract ImageData exportDiagramInternal(OutputStream var1, int var2, FileFormatOption var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void exportCmap(SuggestedFile suggestedFile, int index, ImageData cmapdata) throws FileNotFoundException {
        String name = UmlDiagram.changeName(suggestedFile.getFile(index).getAbsolutePath());
        File cmapFile = new File(name);
        PrintWriter pw = null;
        try {
            if (!PSystemUtils.canFileBeWritten(cmapFile)) {
                return;
            }
            pw = new PrintWriter(cmapFile);
            pw.print(cmapdata.getCMapData(cmapFile.getName().substring(0, cmapFile.getName().length() - 6)));
            pw.close();
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    static String changeName(String name) {
        return name.replaceAll("(?i)\\.\\w{3}$", ".cmapx");
    }

    @Override
    public String getWarningOrError() {
        if (this.lastInfo == null) {
            return null;
        }
        double actualWidth = this.lastInfo.getWidth();
        if (actualWidth == 0.0) {
            return null;
        }
        String value = this.getSkinParam().getValue("widthwarning");
        if (value == null) {
            return null;
        }
        if (!value.matches("\\d+")) {
            return null;
        }
        int widthwarning = Integer.parseInt(value);
        if (actualWidth > (double)widthwarning) {
            return "The image is " + (int)actualWidth + " pixel width. (Warning limit is " + widthwarning + ")";
        }
        return null;
    }

    public void addSprite(String name, Sprite sprite) {
        this.skinParam.addSprite(name, sprite);
    }

    @Override
    public final DisplayPositionned getLegend() {
        return this.legend;
    }

    public final void setLegend(DisplayPositionned legend) {
        this.legend = legend;
    }

    public void setUseJDot(boolean useJDot) {
        this.useJDot = useJDot;
    }

    public boolean isUseJDot() {
        return this.useJDot;
    }

    public void setDotExecutable(String dotExecutable) {
        this.skinParam.setDotExecutable(dotExecutable);
    }
}

