/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.code;

import java.io.IOException;
import net.sourceforge.plantuml.code.AsciiEncoder;
import net.sourceforge.plantuml.code.AsciiEncoderBase64;
import net.sourceforge.plantuml.code.CompressionBrotli;
import net.sourceforge.plantuml.code.CompressionHuffman;
import net.sourceforge.plantuml.code.CompressionZlib;
import net.sourceforge.plantuml.code.Transcoder;
import net.sourceforge.plantuml.code.TranscoderImpl;

public class TranscoderSmart
implements Transcoder {
    private final Transcoder oldOne = new TranscoderImpl(new AsciiEncoder(), new CompressionHuffman());
    private final Transcoder zlibBase64 = new TranscoderImpl(new AsciiEncoderBase64(), new CompressionZlib());
    private final Transcoder zlib = new TranscoderImpl(new AsciiEncoder(), new CompressionZlib());
    private final Transcoder brotliBase64 = new TranscoderImpl(new AsciiEncoderBase64(), new CompressionBrotli());

    @Override
    public String decode(String code) throws IOException {
        if (code.startsWith("0")) {
            return this.zlibBase64.decode(code.substring(1));
        }
        if (code.startsWith("1")) {
            return this.brotliBase64.decode(code.substring(1));
        }
        try {
            return this.zlib.decode(code);
        }
        catch (Exception ex) {
            return this.oldOne.decode(code);
        }
    }

    @Override
    public String encode(String text) throws IOException {
        return this.zlib.encode(text);
    }
}

