/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.geom.Dijkstra;
import net.sourceforge.plantuml.geom.LineSegmentInt;
import net.sourceforge.plantuml.geom.Neighborhood;
import net.sourceforge.plantuml.geom.Orientation;
import net.sourceforge.plantuml.geom.Point2DInt;
import net.sourceforge.plantuml.geom.Pointable;
import net.sourceforge.plantuml.geom.Polyline;
import net.sourceforge.plantuml.geom.PolylineImpl;
import net.sourceforge.plantuml.geom.Singularity;

abstract class AbstractFigure {
    private final Set<LineSegmentInt> segments = new HashSet<LineSegmentInt>();

    AbstractFigure() {
    }

    public String toString() {
        return this.segments.toString();
    }

    public final boolean equals(Object obj) {
        AbstractFigure other = (AbstractFigure)obj;
        return this.segments.equals(other.segments);
    }

    public final int hashCode() {
        return this.segments.hashCode();
    }

    protected boolean knowThisPoint(Point2DInt p) {
        for (LineSegmentInt seg : this.segments) {
            if (!seg.getP1().equals(p) && !seg.getP2().equals(p)) continue;
            return true;
        }
        return false;
    }

    LineSegmentInt existingSegment(Point2DInt p1, Point2DInt p2) {
        for (LineSegmentInt seg : this.segments) {
            if (seg.getP1().equals(p1) && seg.getP2().equals(p2)) {
                return seg;
            }
            if (!seg.getP1().equals(p2) || !seg.getP2().equals(p1)) continue;
            return seg;
        }
        return null;
    }

    Collection<LineSegmentInt> getSegmentsWithExtremity(Point2DInt extremity, Collection<LineSegmentInt> exceptions) {
        HashSet<LineSegmentInt> result = new HashSet<LineSegmentInt>();
        for (LineSegmentInt seg : this.segments) {
            if (exceptions.contains(seg) || !seg.getP1().equals(extremity) && !seg.getP2().equals(extremity)) continue;
            result.add(seg);
        }
        return Collections.unmodifiableCollection(result);
    }

    public void addSegment(LineSegmentInt seg) {
        this.segments.add(seg);
    }

    protected final Set<LineSegmentInt> getSegments() {
        return Collections.unmodifiableSet(this.segments);
    }

    @Deprecated
    public Polyline addPath(Point2DInt start, Point2DInt end) {
        if (this.knowThisPoint(start) && this.knowThisPoint(end)) {
            return this.getPath(start, end);
        }
        LineSegmentInt direct = new LineSegmentInt(start, end);
        this.addSegment(direct);
        return new PolylineImpl(start, end);
    }

    public Polyline addDirectLink(Point2DInt start, Point2DInt end) {
        LineSegmentInt direct = new LineSegmentInt(start, end);
        this.addSegment(direct);
        Log.println("AbstractFigure::addDirectLink " + direct);
        return new PolylineImpl(start, end);
    }

    public boolean isSimpleSegmentPossible(Point2DInt start, Point2DInt end) {
        LineSegmentInt direct = new LineSegmentInt(start, end);
        return !this.hasIntersectionStrict(direct);
    }

    public Polyline getPath(Pointable start, Pointable end) {
        if (!this.knowThisPoint(start.getPosition())) {
            throw new IllegalArgumentException();
        }
        if (!this.knowThisPoint(end.getPosition())) {
            throw new IllegalArgumentException("" + end.getPosition());
        }
        if (this.isSimpleSegmentPossible(start.getPosition(), end.getPosition())) {
            throw new IllegalArgumentException();
        }
        if (!this.arePointsConnectable(start.getPosition(), end.getPosition())) {
            return null;
        }
        return this.findBestPath(start, end);
    }

    private Polyline findBestPath(Pointable start, Pointable end) {
        int i;
        Log.println("start=" + start.getPosition());
        Log.println("end=" + end.getPosition());
        Set<Point2DInt> points = this.getAllPoints();
        if (!points.contains(start.getPosition()) || !points.contains(end.getPosition())) {
            throw new IllegalArgumentException();
        }
        points.remove(start.getPosition());
        points.remove(end.getPosition());
        ArrayList<Neighborhood> neighborhoods = new ArrayList<Neighborhood>();
        for (Point2DInt p : points) {
            neighborhoods.addAll(this.getSingularity(p).getNeighborhoods());
        }
        for (int i2 = 0; i2 < neighborhoods.size(); ++i2) {
            Log.println("N" + (i2 + 1) + " " + neighborhoods.get(i2));
        }
        Dijkstra dijkstra = new Dijkstra(neighborhoods.size() + 2);
        Log.println("size=" + dijkstra.getSize());
        for (i = 0; i < neighborhoods.size(); ++i) {
            if (!this.isConnectable(start.getPosition(), (Neighborhood)neighborhoods.get(i))) continue;
            dijkstra.addLink(0, i + 1, AbstractFigure.distance(start.getPosition(), ((Neighborhood)neighborhoods.get(i)).getCenter()));
        }
        for (i = 0; i < neighborhoods.size(); ++i) {
            for (int j = 0; j < neighborhoods.size(); ++j) {
                if (i == j || !this.isConnectable((Neighborhood)neighborhoods.get(i), (Neighborhood)neighborhoods.get(j))) continue;
                dijkstra.addLink(i + 1, j + 1, AbstractFigure.distance(((Neighborhood)neighborhoods.get(i)).getCenter(), ((Neighborhood)neighborhoods.get(j)).getCenter()));
            }
        }
        for (i = 0; i < neighborhoods.size(); ++i) {
            if (!this.isConnectable(end.getPosition(), (Neighborhood)neighborhoods.get(i))) continue;
            dijkstra.addLink(i + 1, neighborhoods.size() + 1, AbstractFigure.distance(end.getPosition(), ((Neighborhood)neighborhoods.get(i)).getCenter()));
        }
        List<Integer> path2 = dijkstra.getBestPath();
        if (path2.get(path2.size() - 1) != neighborhoods.size() + 1) {
            throw new IllegalStateException("No Path");
        }
        assert (path2.size() > 2);
        Log.println("PATH=" + path2);
        ArrayList<Neighborhood> usedNeighborhoods = new ArrayList<Neighborhood>();
        for (int i3 = 1; i3 < path2.size() - 1; ++i3) {
            int idx = path2.get(i3) - 1;
            usedNeighborhoods.add((Neighborhood)neighborhoods.get(idx));
        }
        return this.findApproximatePath(start, end, usedNeighborhoods);
    }

    private Polyline findApproximatePath(Pointable start, Pointable end, List<Neighborhood> neighborhoods) {
        System.err.println("findApproximatePath " + start.getPosition() + " " + end.getPosition() + " " + neighborhoods);
        PolylineImpl result = new PolylineImpl(start, end);
        for (Neighborhood n : neighborhoods) {
            Log.println("Neighborhood =" + n);
            double d = this.getProximaDistance(n.getCenter()) / 2.0;
            double a = n.getMiddle();
            Log.println("d=" + d);
            Log.println("a=" + a * 180.0 / Math.PI);
            double deltaX = d * Math.cos(a);
            double deltaY = d * Math.sin(a);
            assert (d > 0.0);
            Log.println("Result = " + n.getCenter().translate((int)deltaX, (int)deltaY));
            result.addIntermediate(n.getCenter().translate((int)deltaX, (int)deltaY));
        }
        return result;
    }

    private double getProximaDistance(Point2DInt center) {
        double result = Double.MAX_VALUE;
        for (Point2DInt p : this.getAllPoints()) {
            if (center.equals(p)) continue;
            double cur = new LineSegmentInt(p, center).getLength();
            result = Math.min(result, cur);
        }
        return result;
    }

    private static double distance(Point2DInt p1, Point2DInt p2) {
        return new LineSegmentInt(p1, p2).getLength();
    }

    public boolean isConnectable(Point2DInt p, Neighborhood n) {
        LineSegmentInt seg = new LineSegmentInt(n.getCenter(), p);
        if (this.hasIntersectionStrict(seg)) {
            return false;
        }
        double angle = Singularity.convertAngle(seg.getAngle());
        return n.isInAngleLarge(angle);
    }

    public boolean isConnectable(Neighborhood n1, Neighborhood n2) {
        boolean result = this.isConnectableInternal(n1, n2);
        assert (result == this.isConnectableInternal(n2, n1));
        return result;
    }

    private boolean isConnectableInternal(Neighborhood n1, Neighborhood n2) {
        if (n1.getCenter().equals(n2.getCenter())) {
            return false;
        }
        LineSegmentInt seg1 = new LineSegmentInt(n1.getCenter(), n2.getCenter());
        if (this.hasIntersectionStrict(seg1)) {
            return false;
        }
        double angle1 = Singularity.convertAngle(seg1.getAngle());
        double angle2 = Singularity.convertAngle(seg1.getOppositeAngle());
        assert (angle2 == Singularity.convertAngle(new LineSegmentInt(n2.getCenter(), n1.getCenter()).getAngle()));
        if (n1.isInAngleStrict(angle1) && n2.isInAngleStrict(angle2)) {
            return true;
        }
        if (n1.isAngleLimit(angle1) && n2.isAngleLimit(angle2)) {
            Orientation o2;
            if (n1.is360() || n2.is360()) {
                return true;
            }
            Orientation o1 = n1.getOrientationFrom(angle1);
            return o1 != (o2 = n2.getOrientationFrom(angle2));
        }
        return false;
    }

    private boolean hasIntersectionStrict(LineSegmentInt direct) {
        for (LineSegmentInt seg : this.getSegments()) {
            if (seg.atLeastOneCommonExtremities(direct) || !seg.doesIntersect(direct)) continue;
            Log.println("seg=" + seg);
            Log.println("direct=" + direct);
            Log.println("AbstractFigure::hasIntersectionStrict true");
            return true;
        }
        Log.println("AbstractFigure::hasIntersectionStrict false");
        return false;
    }

    public Singularity getSingularity(Point2DInt center) {
        Singularity singularity = new Singularity(center);
        for (LineSegmentInt seg : this.getSegments()) {
            if (!seg.containsPoint(center)) continue;
            singularity.addLineSegment(seg);
        }
        return singularity;
    }

    private Set<Point2DInt> getAllPoints() {
        HashSet<Point2DInt> result = new HashSet<Point2DInt>();
        for (LineSegmentInt seg : this.segments) {
            result.add(seg.getP1());
            result.add(seg.getP2());
        }
        return result;
    }

    abstract boolean arePointsConnectable(Point2DInt var1, Point2DInt var2);
}

