/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.CompressionTransform;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.SlotFinder;
import net.sourceforge.plantuml.ugraphic.SlotSet;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphicCompress;

public class TextBlockCompressed
extends AbstractTextBlock
implements TextBlock {
    private final TextBlock textBlock;
    private MinMax cachedMinMax;
    private CompressionTransform cachedCompressionTransform;

    public TextBlockCompressed(TextBlock textBlock) {
        this.textBlock = textBlock;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        CompressionTransform compressionTransform = this.getCompressionTransform(stringBounder);
        this.textBlock.drawU(new UGraphicCompress(ug, compressionTransform));
    }

    @Override
    public MinMax getMinMax(StringBounder stringBounder) {
        if (this.cachedMinMax == null) {
            this.cachedMinMax = TextBlockUtils.getMinMax(this, stringBounder);
        }
        return this.cachedMinMax;
    }

    private CompressionTransform getCompressionTransform(StringBounder stringBounder) {
        if (this.cachedCompressionTransform == null) {
            this.cachedCompressionTransform = this.getCompressionTransformSlow(stringBounder);
        }
        return this.cachedCompressionTransform;
    }

    private CompressionTransform getCompressionTransformSlow(StringBounder stringBounder) {
        SlotFinder slotFinder = new SlotFinder(stringBounder);
        this.textBlock.drawU(slotFinder);
        SlotSet ysSlotSet = slotFinder.getYSlotSet().reverse().smaller(5.0);
        CompressionTransform compressionTransform = new CompressionTransform(ysSlotSet);
        return compressionTransform;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        CompressionTransform compressionTransform = this.getCompressionTransform(stringBounder);
        Dimension2D dim = this.textBlock.calculateDimension(stringBounder);
        return new Dimension2DDouble(dim.getWidth(), compressionTransform.transform(dim.getHeight()));
    }
}

