/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.SkinParameter;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphicStencil;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class USymbolCloud
extends USymbol {
    USymbolCloud() {
    }

    @Override
    public SkinParameter getSkinParameter() {
        return SkinParameter.CLOUD;
    }

    private void drawCloud(UGraphic ug, double width, double height, boolean shadowing) {
        UPath shape = this.getSpecificFrontierForCloud(width, height);
        if (shadowing) {
            shape.setDeltaShadow(3.0);
        }
        ug.apply(new UTranslate(3.0, -3.0)).draw(shape);
    }

    private UPath getSpecificFrontierForCloud(double width, double height) {
        UPath path2 = new UPath();
        path2.moveTo(0.0, 10.0);
        double x = 0.0;
        int i = 0;
        while ((double)i < width - 9.0) {
            path2.cubicTo(i, 7.0, 2 + i, 5.0, 5 + i, 5.0);
            path2.cubicTo(8 + i, 5.0, 10 + i, 7.0, 10 + i, 10.0);
            x = i + 10;
            i += 10;
        }
        double y = 0.0;
        int j = 10;
        while ((double)j < height - 9.0) {
            path2.cubicTo(x + 3.0, j, x + 5.0, 2 + j, x + 5.0, 5 + j);
            path2.cubicTo(x + 5.0, 8 + j, x + 3.0, 10 + j, x, 10 + j);
            y = j + 10;
            j += 10;
        }
        int i2 = 0;
        while ((double)i2 < width - 9.0) {
            path2.cubicTo(x - (double)i2, y + 3.0, x - 3.0 - (double)i2, y + 5.0, x - 5.0 - (double)i2, y + 5.0);
            path2.cubicTo(x - 8.0 - (double)i2, y + 5.0, x - 10.0 - (double)i2, y + 3.0, x - 10.0 - (double)i2, y);
            i2 += 10;
        }
        j = 0;
        while ((double)j < height - 9.0 - 10.0) {
            path2.cubicTo(-3.0, y - (double)j, -5.0, y - 2.0 - (double)j, -5.0, y - 5.0 - (double)j);
            path2.cubicTo(-5.0, y - 8.0 - (double)j, -3.0, y - 10.0 - (double)j, 0.0, y - 10.0 - (double)j);
            j += 10;
        }
        return path2;
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(10.0, 10.0, 10.0, 10.0);
    }

    @Override
    public TextBlock asSmall(TextBlock name, final TextBlock label, final TextBlock stereotype, final SymbolContext symbolContext) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                Dimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = UGraphicStencil.create(ug, USymbolCloud.this.getRectangleStencil(dim), new UStroke());
                ug = symbolContext.apply(ug);
                USymbolCloud.this.drawCloud(ug, dim.getWidth(), dim.getHeight(), symbolContext.isShadowing());
                USymbol.Margin margin = USymbolCloud.this.getMargin();
                TextBlock tb = TextBlockUtils.mergeTB(stereotype, label, HorizontalAlignment.CENTER);
                tb.drawU(ug.apply(new UTranslate(margin.getX1(), margin.getY1())));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dimLabel = label.calculateDimension(stringBounder);
                Dimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                return USymbolCloud.this.getMargin().addDimension(Dimension2DDouble.mergeTB(dimStereo, dimLabel));
            }
        };
    }

    @Override
    public TextBlock asBig(final TextBlock title, HorizontalAlignment labelAlignment, final TextBlock stereotype, final double width, final double height, final SymbolContext symbolContext) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                Dimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = symbolContext.apply(ug);
                USymbolCloud.this.drawCloud(ug, dim.getWidth(), dim.getHeight(), symbolContext.isShadowing());
                Dimension2D dimStereo = stereotype.calculateDimension(ug.getStringBounder());
                double posStereo = (width - dimStereo.getWidth()) / 2.0;
                stereotype.drawU(ug.apply(new UTranslate(posStereo, 13.0)));
                Dimension2D dimTitle = title.calculateDimension(ug.getStringBounder());
                double posTitle = (width - dimTitle.getWidth()) / 2.0;
                title.drawU(ug.apply(new UTranslate(posTitle, 13.0 + dimStereo.getHeight())));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(width, height);
            }
        };
    }

    @Override
    public boolean manageHorizontalLine() {
        return true;
    }
}

