/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.brotli.BrotliInputStream;

public class StdlibOld {
    private static final Map<String, StdlibOld> all = new ConcurrentHashMap<String, StdlibOld>();
    private final Map<String, Portion> data = new HashMap<String, Portion>();
    private final Map<String, SoftReference<byte[]>> cache = new ConcurrentHashMap<String, SoftReference<byte[]>>();
    private final String name;
    private final Map<String, String> info = new HashMap<String, String>();

    public static InputStream getResourceAsStream(String fullname) {
        int last = (fullname = fullname.toLowerCase().replace(".puml", "")).indexOf(47);
        if (last == -1) {
            return null;
        }
        try {
            StdlibOld folder = StdlibOld.retrieve(fullname.substring(0, last));
            if (folder == null) {
                return null;
            }
            byte[] data = folder.getData(fullname.substring(last + 1));
            if (data == null) {
                return null;
            }
            return new ByteArrayInputStream(data);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static InputStream getInternalInputStream(String fullname, String extension) {
        String res = "/stdlib/" + fullname + extension;
        return StdlibOld.class.getResourceAsStream(res);
    }

    private static StdlibOld retrieve(String name) throws IOException {
        StdlibOld result = all.get(name);
        if (result == null) {
            result = new StdlibOld(name);
            all.put(name, result);
        }
        return result;
    }

    private StdlibOld(String name) throws IOException {
        String filename;
        this.name = name;
        Log.info("Opening archive " + name);
        int pos = 0;
        DataInputStream is = this.getDataIndex();
        this.fillMap(is.readUTF());
        while ((filename = is.readUTF()).length() != 0) {
            int len = is.readInt();
            this.data.put(filename.toLowerCase(), new Portion(pos, len));
            pos += len;
        }
        is.close();
    }

    private void fillMap(String infoString) {
        for (String s : infoString.split("\n")) {
            if (!s.contains("=")) continue;
            String[] data = s.split("=");
            this.info.put(data[0], data[1]);
        }
    }

    private DataInputStream getDataIndex() {
        InputStream raw = StdlibOld.getInternalInputStream(this.name, "-idx.repx");
        if (raw == null) {
            return null;
        }
        return new DataInputStream(raw);
    }

    private DataInputStream getFullTexts() throws IOException {
        InputStream raw = StdlibOld.getInternalInputStream(this.name, "-dat.repx");
        if (raw == null) {
            return null;
        }
        return new DataInputStream(new BrotliInputStream(raw));
    }

    private byte[] getData(String filename) throws IOException {
        SoftReference<byte[]> ref = this.cache.get(filename);
        byte[] result = ref == null ? null : ref.get();
        String full = this.name + "/" + filename + ".puml";
        if (result == null) {
            result = this.getDataSlow(filename);
            this.cache.put(filename, new SoftReference<byte[]>(result));
            Log.info("Reading " + full);
        } else {
            Log.info("Retrieving " + full);
        }
        return result;
    }

    private byte[] getDataSlow(String filename) throws IOException {
        Portion portion = this.data.get(filename);
        return portion.of(this.getFullTexts());
    }

    public static void extractStdLib() throws IOException {
        for (String name : StdlibOld.getAll()) {
            StdlibOld folder = new StdlibOld(name);
            folder.extractMeFull(new File("stdlib", name));
        }
    }

    private static List<String> getAll() throws IOException {
        String name;
        ArrayList<String> result = new ArrayList<String>();
        InputStream home = StdlibOld.getInternalInputStream("home", ".repx");
        BufferedReader br = new BufferedReader(new InputStreamReader(home));
        while ((name = br.readLine()) != null) {
            result.add(name);
        }
        return Collections.unmodifiableList(result);
    }

    private void extractMeFull(File dir) throws IOException {
        DataInputStream idx = this.getDataIndex();
        DataInputStream txt = this.getFullTexts();
        String infoString = idx.readUTF();
        while (true) {
            String filename;
            if ((filename = idx.readUTF()).length() == 0) {
                idx.close();
                txt.close();
                return;
            }
            int len = idx.readInt();
            File f = new File("stdlib/" + this.name + "/" + filename + ".puml");
            f.getParentFile().mkdirs();
            FileOutputStream fos = new FileOutputStream(f);
            byte[] data = new byte[len];
            txt.readFully(data);
            fos.write(data);
            fos.close();
        }
    }

    public static void addInfoVersion(List<String> strings) {
        try {
            for (String name : StdlibOld.getAll()) {
                StdlibOld folder = new StdlibOld(name);
                strings.add("* " + name + " (Version " + folder.getVersion() + ")");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getVersion() {
        return this.info.get("VERSION");
    }

    static class Portion {
        int position;
        int length;

        Portion(int position, int length) {
            this.position = position;
            this.length = length;
        }

        public byte[] of(DataInputStream is) throws IOException {
            is.skipBytes(this.position);
            byte[] result = new byte[this.length];
            is.readFully(result);
            is.close();
            return result;
        }
    }
}

