/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.Scale;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorSetSimple;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.IHtmlColorSet;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.project3.DayAsDate;
import net.sourceforge.plantuml.project3.DayOfWeek;
import net.sourceforge.plantuml.project3.GCalendar;
import net.sourceforge.plantuml.project3.GCalendarSimple;
import net.sourceforge.plantuml.project3.GanttConstraint;
import net.sourceforge.plantuml.project3.Instant;
import net.sourceforge.plantuml.project3.InstantDay;
import net.sourceforge.plantuml.project3.LoadPlanable;
import net.sourceforge.plantuml.project3.Month;
import net.sourceforge.plantuml.project3.Resource;
import net.sourceforge.plantuml.project3.ResourceDraw;
import net.sourceforge.plantuml.project3.Subject;
import net.sourceforge.plantuml.project3.Task;
import net.sourceforge.plantuml.project3.TaskAttribute;
import net.sourceforge.plantuml.project3.TaskCode;
import net.sourceforge.plantuml.project3.TaskCodeSimpleOrder;
import net.sourceforge.plantuml.project3.TaskDraw;
import net.sourceforge.plantuml.project3.TaskDrawRegular;
import net.sourceforge.plantuml.project3.TaskDrawSeparator;
import net.sourceforge.plantuml.project3.TaskImpl;
import net.sourceforge.plantuml.project3.TaskInstant;
import net.sourceforge.plantuml.project3.TaskSeparator;
import net.sourceforge.plantuml.project3.TimeScale;
import net.sourceforge.plantuml.project3.TimeScaleBasic;
import net.sourceforge.plantuml.project3.TimeScaleBasic2;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class GanttDiagram
extends AbstractPSystem
implements Subject {
    private final Map<TaskCode, Task> tasks = new LinkedHashMap<TaskCode, Task>();
    private final Map<String, Task> byShortName = new HashMap<String, Task>();
    private final List<GanttConstraint> constraints = new ArrayList<GanttConstraint>();
    private final IHtmlColorSet colorSet = new HtmlColorSetSimple();
    private final Collection<DayOfWeek> closedDayOfWeek = EnumSet.noneOf(DayOfWeek.class);
    private final Collection<DayAsDate> closedDayAsDate = new HashSet<DayAsDate>();
    private GCalendar calendar;
    private final Instant min = new InstantDay(0);
    private Instant max;
    private int horizontalPages = 1;
    private int verticalPages = 1;
    private final HtmlColor veryLightGray = new HtmlColorSetSimple().getColorIfValid("#E0E8E8");
    private static final int Y_WEEKDAY = 16;
    private static final int Y_NUMDAY = 28;
    private final Map<String, Resource> resources = new LinkedHashMap<String, Resource>();

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Project)");
    }

    public final int getHorizontalPages() {
        return this.horizontalPages;
    }

    public final void setHorizontalPages(int horizontalPages) {
        this.horizontalPages = horizontalPages;
    }

    public final int getVerticalPages() {
        return this.verticalPages;
    }

    public final void setVerticalPages(int verticalPages) {
        this.verticalPages = verticalPages;
    }

    @Override
    public int getNbImages() {
        return this.horizontalPages * this.verticalPages;
    }

    public final int getDpi(FileFormatOption fileFormatOption) {
        return 96;
    }

    @Override
    protected ImageData exportDiagramNow(OutputStream os, int index, FileFormatOption fileFormatOption, long seed) throws IOException {
        double margin = 10.0;
        this.sortTasks();
        Scale scale = this.getScale();
        double dpiFactor = scale == null ? 1.0 : scale.getScale(100.0, 100.0);
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), dpiFactor, null, "", "", 0.0, 0.0, null, false);
        UDrawable result = this.getUDrawable();
        imageBuilder.setUDrawable(result);
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption, seed, os);
    }

    private void sortTasks() {
        final TaskCodeSimpleOrder order = this.getCanonicalOrder(1);
        ArrayList<Task> list = new ArrayList<Task>(this.tasks.values());
        Collections.sort(list, new Comparator<Task>(){

            @Override
            public int compare(Task task1, Task task2) {
                return order.compare(task1.getCode(), task2.getCode());
            }
        });
        this.tasks.clear();
        for (Task task : list) {
            this.tasks.put(task.getCode(), task);
        }
    }

    private UDrawable getUDrawable() {
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                GanttDiagram.this.initMinMax();
                TimeScale timeScale = GanttDiagram.this.getTimeScale();
                GanttDiagram.this.drawTimeHeader(ug, timeScale);
                GanttDiagram.this.drawTasks(ug, timeScale);
                GanttDiagram.this.drawConstraints(ug, timeScale);
            }
        };
    }

    private TimeScale getTimeScale() {
        if (this.calendar == null) {
            return new TimeScaleBasic();
        }
        return new TimeScaleBasic2(this.getCalendarSimple());
    }

    private GCalendarSimple getCalendarSimple() {
        return (GCalendarSimple)this.calendar;
    }

    public LoadPlanable getDefaultPlan() {
        return new LoadPlanable(){

            @Override
            public int getLoadAt(Instant instant) {
                if (GanttDiagram.this.calendar == null) {
                    return 100;
                }
                DayAsDate day = GanttDiagram.this.getCalendarSimple().toDayAsDate((InstantDay)instant);
                DayOfWeek dayOfWeek = day.getDayOfWeek();
                if (GanttDiagram.this.closedDayOfWeek.contains(dayOfWeek) || GanttDiagram.this.closedDayAsDate.contains(day)) {
                    return 0;
                }
                return 100;
            }
        };
    }

    private void drawConstraints(UGraphic ug, TimeScale timeScale) {
        for (GanttConstraint constraint : this.constraints) {
            constraint.getUDrawable(timeScale).drawU(ug);
        }
    }

    private void drawTimeHeader(UGraphic ug, TimeScale timeScale) {
        double yTotal = this.initTaskAndResourceDraws(timeScale);
        double xmin = timeScale.getStartingPosition(this.min);
        double xmax = timeScale.getEndingPosition(this.max);
        ug.apply(new UChangeColor(HtmlColorUtils.LIGHT_GRAY)).draw(new ULine(xmax - xmin, 0.0));
        ug.apply(new UChangeColor(HtmlColorUtils.LIGHT_GRAY)).apply(new UTranslate(0.0, this.getHeaderHeight() - 3.0)).draw(new ULine(xmax - xmin, 0.0));
        if (this.calendar == null) {
            this.drawSimpleDayCounter(ug, timeScale, yTotal);
        } else {
            this.drawCalendar(ug, timeScale, yTotal);
        }
    }

    private double getHeaderHeight() {
        if (this.calendar != null) {
            return 44.0;
        }
        return 16.0;
    }

    private void drawCalendar(UGraphic ug, TimeScale timeScale, double yTotal) {
        timeScale = new TimeScaleBasic();
        ULine vbar = new ULine(0.0, yTotal - 16.0);
        Month lastMonth = null;
        GCalendarSimple calendarAll = this.getCalendarSimple();
        InstantDay max2 = calendarAll.fromDayAsDate(this.calendar.toDayAsDate((InstantDay)this.max));
        Instant i = this.min;
        while (i.compareTo(max2.increment()) <= 0) {
            DayAsDate day = calendarAll.toDayAsDate((InstantDay)i);
            DayOfWeek dayOfWeek = day.getDayOfWeek();
            boolean isWorkingDay = this.getDefaultPlan().getLoadAt(i) > 0;
            String d1 = "" + day.getDayOfMonth();
            TextBlock num = this.getTextBlock(d1, 10);
            double x1 = timeScale.getStartingPosition(i);
            double x2 = timeScale.getEndingPosition(i);
            if (i.compareTo(max2.increment()) < 0) {
                TextBlock weekDay = this.getTextBlock(dayOfWeek.shortName(), 10);
                if (isWorkingDay) {
                    this.drawCenter(ug.apply(new UTranslate(0.0, 28.0)), num, x1, x2);
                    this.drawCenter(ug.apply(new UTranslate(0.0, 16.0)), weekDay, x1, x2);
                } else {
                    URectangle rect = new URectangle(x2 - x1 - 1.0, yTotal - 16.0);
                    ug.apply(new UChangeColor(null)).apply(new UChangeBackColor(this.veryLightGray)).apply(new UTranslate(x1 + 1.0, 16.0)).draw(rect);
                }
                if (lastMonth != day.getMonth()) {
                    int delta = 5;
                    if (lastMonth != null) {
                        TextBlock lastMonthBlock = this.getTextBlock(lastMonth.name(), 12);
                        lastMonthBlock.drawU(ug.apply(new UTranslate(x1 - lastMonthBlock.calculateDimension(ug.getStringBounder()).getWidth() - 5.0, 0.0)));
                    }
                    TextBlock month = this.getTextBlock(day.getMonth().name(), 12);
                    month.drawU(ug.apply(new UTranslate(x1 + 5.0, 0.0)));
                    ug.apply(new UChangeColor(HtmlColorUtils.LIGHT_GRAY)).apply(new UTranslate(x1, 0.0)).draw(new ULine(0.0, 16.0));
                }
                lastMonth = day.getMonth();
            }
            ug.apply(new UChangeColor(HtmlColorUtils.LIGHT_GRAY)).apply(new UTranslate(x1, 16.0)).draw(vbar);
            i = i.increment();
        }
    }

    private TextBlock getTextBlock(String text, int size) {
        return Display.getWithNewlines(text).create(this.getFontConfiguration(size), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
    }

    private void drawCenter(UGraphic ug, TextBlock text, double x1, double x2) {
        double width = text.calculateDimension(ug.getStringBounder()).getWidth();
        double delta = x2 - x1 - width;
        if (delta < 0.0) {
            return;
        }
        text.drawU(ug.apply(new UTranslate(x1 + delta / 2.0, 0.0)));
    }

    private void drawSimpleDayCounter(UGraphic ug, TimeScale timeScale, double yTotal) {
        ULine vbar = new ULine(0.0, yTotal);
        Instant i = this.min;
        while (i.compareTo(this.max.increment()) <= 0) {
            TextBlock num = Display.getWithNewlines(i.toShortString()).create(this.getFontConfiguration(10), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
            double x1 = timeScale.getStartingPosition(i);
            double x2 = timeScale.getEndingPosition(i);
            double width = num.calculateDimension(ug.getStringBounder()).getWidth();
            double delta = x2 - x1 - width;
            if (i.compareTo(this.max.increment()) < 0) {
                num.drawU(ug.apply(new UTranslate(x1 + delta / 2.0, 0.0)));
            }
            ug.apply(new UChangeColor(HtmlColorUtils.LIGHT_GRAY)).apply(new UTranslate(x1, 0.0)).draw(vbar);
            i = i.increment();
        }
    }

    private double initTaskAndResourceDraws(TimeScale timeScale) {
        UDrawable draw;
        double y = this.getHeaderHeight();
        for (Task task : this.tasks.values()) {
            draw = task instanceof TaskSeparator ? new TaskDrawSeparator((TaskSeparator)task, timeScale, y, this.min, this.max) : new TaskDrawRegular((TaskImpl)task, timeScale, y);
            task.setTaskDraw((TaskDraw)draw);
            y += draw.getHeight();
        }
        for (Resource res : this.resources.values()) {
            draw = new ResourceDraw(this, res, timeScale, y, this.min, this.max);
            res.setTaskDraw((ResourceDraw)draw);
            y += ((ResourceDraw)draw).getHeight();
        }
        return y;
    }

    private void initMinMax() {
        this.max = this.tasks.values().iterator().next().getEnd();
        for (Task task : this.tasks.values()) {
            if (task instanceof TaskSeparator) continue;
            Instant start = task.getStart();
            Instant end = task.getEnd();
            if (this.max.compareTo(end) >= 0) continue;
            this.max = end;
        }
    }

    private void drawTasks(UGraphic ug, TimeScale timeScale) {
        UDrawable draw;
        for (Task task : this.tasks.values()) {
            draw = task.getTaskDraw();
            draw.drawU(ug.apply(new UTranslate(0.0, draw.getY())));
            draw.drawTitle(ug.apply(new UTranslate(0.0, draw.getY())));
        }
        for (Resource res : this.resources.values()) {
            draw = res.getResourceDraw();
            ((ResourceDraw)draw).drawU(ug.apply(new UTranslate(0.0, ((ResourceDraw)draw).getY())));
        }
    }

    private FontConfiguration getFontConfiguration(int size) {
        UFont font = UFont.serif(size);
        if (size > 10) {
            font = font.bold();
        }
        return new FontConfiguration(font, HtmlColorUtils.BLACK, HtmlColorUtils.BLACK, false);
    }

    public Task getExistingTask(String id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        Task result = this.byShortName.get(id);
        if (result != null) {
            return result;
        }
        TaskCode code = new TaskCode(id);
        return this.tasks.get(code);
    }

    public void setTaskOrder(Task task1, Task task2) {
        TaskInstant end1 = new TaskInstant(task1, TaskAttribute.END);
        task2.setStart(end1.getInstantPrecise());
        this.addContraint(new GanttConstraint(end1, new TaskInstant(task2, TaskAttribute.START)));
    }

    public Task getOrCreateTask(String codeOrShortName, String shortName, boolean linkedToPrevious) {
        Task result;
        if (codeOrShortName == null) {
            throw new IllegalArgumentException();
        }
        Task task = result = shortName == null ? null : this.byShortName.get(shortName);
        if (result != null) {
            return result;
        }
        result = this.byShortName.get(codeOrShortName);
        if (result != null) {
            return result;
        }
        TaskCode code = new TaskCode(codeOrShortName);
        result = this.tasks.get(code);
        if (result == null) {
            Task previous = null;
            if (linkedToPrevious) {
                previous = this.getLastCreatedTask();
            }
            result = new TaskImpl(code, this.getDefaultPlan());
            this.tasks.put(code, result);
            if (this.byShortName != null) {
                this.byShortName.put(shortName, result);
            }
            if (previous != null) {
                this.setTaskOrder(previous, result);
            }
        }
        return result;
    }

    private Task getLastCreatedTask() {
        ArrayList<Task> all = new ArrayList<Task>(this.tasks.values());
        for (int i = all.size() - 1; i >= 0; --i) {
            if (!(all.get(i) instanceof TaskImpl)) continue;
            return (Task)all.get(i);
        }
        return null;
    }

    public void addSeparator(String comment) {
        TaskSeparator separator = new TaskSeparator(comment, this.tasks.size());
        this.tasks.put(separator.getCode(), separator);
    }

    private TaskCodeSimpleOrder getCanonicalOrder(int hierarchyHeader) {
        ArrayList<TaskCode> codes = new ArrayList<TaskCode>();
        for (TaskCode code : this.tasks.keySet()) {
            if (code.getHierarchySize() < hierarchyHeader) continue;
            codes.add(code.truncateHierarchy(hierarchyHeader));
        }
        return new TaskCodeSimpleOrder(codes, hierarchyHeader);
    }

    private int getMaxHierarchySize() {
        int max = Integer.MIN_VALUE;
        for (TaskCode code : this.tasks.keySet()) {
            max = Math.max(max, code.getHierarchySize());
        }
        return max;
    }

    public void addContraint(GanttConstraint constraint) {
        this.constraints.add(constraint);
    }

    public IHtmlColorSet getIHtmlColorSet() {
        return this.colorSet;
    }

    public void setStartingDate(DayAsDate start) {
        this.calendar = new GCalendarSimple(start);
    }

    public DayAsDate getStartingDate() {
        return this.calendar.getStartingDate();
    }

    public void closeDayOfWeek(DayOfWeek day) {
        this.closedDayOfWeek.add(day);
    }

    public void closeDayAsDate(DayAsDate day) {
        this.closedDayAsDate.add(day);
    }

    public Instant convert(DayAsDate day) {
        return this.calendar.fromDayAsDate(day);
    }

    public void affectResource(Task result, String resourceName) {
        Resource resource = this.getResource(resourceName);
        result.addResource(resource);
    }

    public Resource getResource(String resourceName) {
        Resource resource = this.resources.get(resourceName);
        if (resource == null) {
            resource = new Resource(resourceName, this.getDefaultPlan());
        }
        this.resources.put(resourceName, resource);
        return resource;
    }

    public int getLoadForResource(Resource res, Instant i) {
        int result = 0;
        for (Task task : this.tasks.values()) {
            if (task instanceof TaskSeparator) continue;
            TaskImpl task2 = (TaskImpl)task;
            result += task2.loadForResource(res, i);
        }
        return result;
    }
}

