/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.project3.Complement;
import net.sourceforge.plantuml.project3.ComplementDate;
import net.sourceforge.plantuml.project3.ComplementDates;
import net.sourceforge.plantuml.project3.ComplementPattern;
import net.sourceforge.plantuml.project3.DayAsDate;
import net.sourceforge.plantuml.project3.DaysAsDates;
import net.sourceforge.plantuml.project3.GanttDiagram;
import net.sourceforge.plantuml.project3.Resource;
import net.sourceforge.plantuml.project3.Subject;
import net.sourceforge.plantuml.project3.Verb;
import net.sourceforge.plantuml.project3.VerbPattern;

public class VerbIsOff
implements VerbPattern {
    @Override
    public Collection<ComplementPattern> getComplements() {
        return Arrays.asList(new ComplementDate(), new ComplementDates());
    }

    @Override
    public IRegex toRegex() {
        return new RegexLeaf("is off on");
    }

    @Override
    public Verb getVerb(final GanttDiagram project, RegexResult arg) {
        return new Verb(){

            @Override
            public CommandExecutionResult execute(Subject subject, Complement complement) {
                Resource resource = (Resource)subject;
                if (complement instanceof DaysAsDates) {
                    for (DayAsDate when : (DaysAsDates)complement) {
                        resource.addCloseDay(project.convert(when));
                    }
                } else {
                    DayAsDate when = (DayAsDate)complement;
                    resource.addCloseDay(project.convert(when));
                }
                return CommandExecutionResult.ok();
            }
        };
    }
}

