/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.sequencediagram.AbstractMessage;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.NoteOnMessage;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import net.sourceforge.plantuml.sequencediagram.teoz.TileWithCallbackY;
import net.sourceforge.plantuml.sequencediagram.teoz.TileWithUpdateStairs;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class CommunicationTileNoteLeft
implements TileWithUpdateStairs,
TileWithCallbackY {
    private final TileWithUpdateStairs tile;
    private final AbstractMessage message;
    private final Skin skin;
    private final ISkinParam skinParam;
    private final LivingSpace livingSpace;
    private final NoteOnMessage noteOnMessage;

    @Override
    public Event getEvent() {
        return this.message;
    }

    public CommunicationTileNoteLeft(TileWithUpdateStairs tile, AbstractMessage message, Skin skin, ISkinParam skinParam, LivingSpace livingSpace, NoteOnMessage noteOnMessage) {
        this.tile = tile;
        this.message = message;
        this.skin = skin;
        this.skinParam = skinParam;
        this.noteOnMessage = noteOnMessage;
        this.livingSpace = livingSpace;
    }

    @Override
    public void updateStairs(StringBounder stringBounder, double y) {
        this.tile.updateStairs(stringBounder, y);
    }

    private Component getComponent(StringBounder stringBounder) {
        Component comp = this.skin.createComponent(ComponentType.NOTE, null, this.noteOnMessage.getSkinParamNoteBackcolored(this.skinParam), this.noteOnMessage.getDisplay());
        return comp;
    }

    private Real getNotePosition(StringBounder stringBounder) {
        Component comp = this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        return this.livingSpace.getPosC(stringBounder).addFixed(-dim.getWidth());
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        Component comp = this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        Area area = new Area(dim.getWidth(), dim.getHeight());
        this.tile.drawU(ug);
        Real p = this.getNotePosition(stringBounder);
        comp.drawU(ug.apply(new UTranslate(p.getCurrentValue(), 0.0)), area, (Context2D)((Object)ug));
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        Component comp = this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        return Math.max(this.tile.getPreferredHeight(stringBounder), dim.getHeight());
    }

    @Override
    public void addConstraints(StringBounder stringBounder) {
        this.tile.addConstraints(stringBounder);
    }

    @Override
    public Real getMinX(StringBounder stringBounder) {
        return this.getNotePosition(stringBounder);
    }

    @Override
    public Real getMaxX(StringBounder stringBounder) {
        return this.tile.getMaxX(stringBounder);
    }

    @Override
    public void callbackY(double y) {
        if (this.tile instanceof TileWithCallbackY) {
            ((TileWithCallbackY)((Object)this.tile)).callbackY(y);
        }
    }
}

