/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.Pragma;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.InstructionList;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.ConnectionCross;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.TextBlockInterceptorUDrawable;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorAddNote;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorAddUrl;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorAssembly;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorCreateGroup;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorCreateParallel;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorIf;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorRepeat;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorWhile;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.UGraphicInterceptorOneSwimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.VCompactFactory;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.UGraphicDelegator;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.svek.UGraphicForSnake;
import net.sourceforge.plantuml.ugraphic.LimitFinder;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.SlotSet;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.utils.MathUtils;

public class Swimlanes
extends AbstractTextBlock
implements TextBlock {
    private final ISkinParam skinParam;
    private final Pragma pragma;
    private final List<Swimlane> swimlanes = new ArrayList<Swimlane>();
    private Swimlane currentSwimlane = null;
    private final Instruction root;
    private Instruction currentInstruction = this.root = new InstructionList();
    private LinkRendering nextLinkRenderer = LinkRendering.none();
    private static final double separationMargin = 10.0;
    private TextBlock full;
    private MinMax cachedMinMax;

    public Swimlanes(ISkinParam skinParam, Pragma pragma) {
        this.skinParam = skinParam;
        this.pragma = pragma;
    }

    private FontConfiguration getFontConfiguration() {
        return new FontConfiguration(this.skinParam, FontParam.SWIMLANE_TITLE, null);
    }

    private FtileFactory getFtileFactory(StringBounder stringBounder) {
        FtileFactory factory = new VCompactFactory(this.skinParam, stringBounder);
        factory = new FtileFactoryDelegatorAddUrl(factory);
        factory = new FtileFactoryDelegatorAssembly(factory);
        factory = new FtileFactoryDelegatorIf(factory, this.pragma);
        factory = new FtileFactoryDelegatorWhile(factory);
        factory = new FtileFactoryDelegatorRepeat(factory);
        factory = new FtileFactoryDelegatorCreateParallel(factory);
        factory = new FtileFactoryDelegatorAddNote(factory);
        factory = new FtileFactoryDelegatorCreateGroup(factory);
        return factory;
    }

    public void swimlane(String name, HtmlColor color, Display label) {
        this.currentSwimlane = this.getOrCreate(name);
        if (color != null) {
            this.currentSwimlane.setSpecificColorTOBEREMOVED(ColorType.BACK, color);
        }
        if (!Display.isNull(label)) {
            this.currentSwimlane.setDisplay(label);
        }
    }

    private Swimlane getOrCreate(String name) {
        for (Swimlane s : this.swimlanes) {
            if (!s.getName().equals(name)) continue;
            return s;
        }
        Swimlane result = new Swimlane(name);
        this.swimlanes.add(result);
        return result;
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.full == null) {
            FtileFactory factory = this.getFtileFactory(ug.getStringBounder());
            this.full = this.root.createFtile(factory);
            if (this.swimlanes.size() <= 1) {
                this.full = new TextBlockInterceptorUDrawable(this.full);
            }
        }
        ug = new UGraphicForSnake(ug);
        if (this.swimlanes.size() <= 1) {
            this.full.drawU(ug);
            ug.flushUg();
            return;
        }
        this.drawWhenSwimlanes(ug, this.full);
    }

    private static void printDebug(UGraphic ug, SlotSet slot, HtmlColor col, TextBlock full) {
        slot.drawDebugX(ug.apply(new UChangeColor(col)).apply(new UChangeBackColor(col)), full.calculateDimension(ug.getStringBounder()).getHeight());
    }

    private void drawWhenSwimlanes(UGraphic ug, TextBlock full) {
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimensionFull = full.calculateDimension(stringBounder);
        UTranslate titleHeightTranslate = this.getTitleHeightTranslate(stringBounder);
        this.computeSize(ug, full);
        double x2 = 0.0;
        for (Swimlane swimlane : this.swimlanes) {
            HtmlColor back = swimlane.getColors(this.skinParam).getColor(ColorType.BACK);
            if (back != null) {
                UGraphic background = ug.apply(new UChangeBackColor(back)).apply(new UChangeColor(back)).apply(new UTranslate(x2, 0.0));
                background.draw(new URectangle(swimlane.getTotalWidth(), dimensionFull.getHeight() + titleHeightTranslate.getDy()));
            }
            TextBlock swTitle = swimlane.getDisplay().create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
            double titleWidth = swTitle.calculateDimension(stringBounder).getWidth();
            double posTitle = x2 + (swimlane.getTotalWidth() - titleWidth) / 2.0;
            swTitle.drawU(ug.apply(new UTranslate(posTitle, 0.0)));
            this.drawSeparation(ug.apply(new UTranslate(x2, 0.0)), dimensionFull.getHeight() + titleHeightTranslate.getDy());
            full.drawU(new UGraphicInterceptorOneSwimlane(ug, swimlane).apply(swimlane.getTranslate()).apply(titleHeightTranslate));
            x2 += swimlane.getTotalWidth();
        }
        this.drawSeparation(ug.apply(new UTranslate(x2, 0.0)), dimensionFull.getHeight() + titleHeightTranslate.getDy());
        Cross cross = new Cross(ug.apply(titleHeightTranslate));
        full.drawU(cross);
        cross.flushUg();
    }

    private void computeDrawingWidths(UGraphic ug, TextBlock full) {
        StringBounder stringBounder = ug.getStringBounder();
        for (Swimlane swimlane : this.swimlanes) {
            LimitFinder limitFinder = new LimitFinder(stringBounder, false);
            UGraphicInterceptorOneSwimlane interceptor = new UGraphicInterceptorOneSwimlane(new UGraphicForSnake(limitFinder), swimlane);
            full.drawU(interceptor);
            interceptor.flushUg();
            MinMax minMax = limitFinder.getMinMax();
            swimlane.setMinMax(minMax);
        }
    }

    private void computeSize(UGraphic ug, TextBlock full) {
        MinMax minMax;
        this.computeDrawingWidths(ug, full);
        double x1 = 0.0;
        StringBounder stringBounder = ug.getStringBounder();
        double swimlaneWidth = this.skinParam.swimlaneWidth();
        if (swimlaneWidth == -1.0) {
            for (Swimlane swimlane : this.swimlanes) {
                minMax = swimlane.getMinMax();
                swimlaneWidth = Math.max(swimlaneWidth, minMax.getWidth());
            }
        }
        for (Swimlane swimlane : this.swimlanes) {
            minMax = swimlane.getMinMax();
            double drawingWidth = minMax.getWidth() + 20.0;
            TextBlock swTitle = swimlane.getDisplay().create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
            double titleWidth = swTitle.calculateDimension(stringBounder).getWidth();
            double totalWidth = MathUtils.max(swimlaneWidth, drawingWidth, titleWidth + 20.0);
            UTranslate translate = new UTranslate(x1 - minMax.getMinX() + 10.0 + (totalWidth - drawingWidth) / 2.0, 0.0);
            swimlane.setTranslateAndWidth(translate, totalWidth);
            x1 += totalWidth;
        }
    }

    private UTranslate getTitleHeightTranslate(StringBounder stringBounder) {
        double titlesHeight = 0.0;
        for (Swimlane swimlane : this.swimlanes) {
            TextBlock swTitle = swimlane.getDisplay().create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
            titlesHeight = Math.max(titlesHeight, swTitle.calculateDimension(stringBounder).getHeight());
        }
        UTranslate titleHeightTranslate = new UTranslate(0.0, titlesHeight);
        return titleHeightTranslate;
    }

    private void drawSeparation(UGraphic ug, double height) {
        HtmlColor color = this.skinParam.getHtmlColor(ColorParam.swimlaneBorder, null, false);
        if (color == null) {
            color = ColorParam.swimlaneBorder.getDefaultValue();
        }
        UStroke thickness = Rose.getStroke(this.skinParam, LineParam.swimlaneBorder, 2.0);
        ug.apply(thickness).apply(new UChangeColor(color)).draw(new ULine(0.0, height));
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.getMinMax(stringBounder).getDimension();
    }

    public Instruction getCurrent() {
        return this.currentInstruction;
    }

    public void setCurrent(Instruction current) {
        this.currentInstruction = current;
    }

    public LinkRendering nextLinkRenderer() {
        return this.nextLinkRenderer;
    }

    public void setNextLinkRenderer(LinkRendering link) {
        if (link == null) {
            throw new IllegalArgumentException();
        }
        this.nextLinkRenderer = link;
    }

    public Swimlane getCurrentSwimlane() {
        return this.currentSwimlane;
    }

    @Override
    public MinMax getMinMax(StringBounder stringBounder) {
        if (this.cachedMinMax == null) {
            this.cachedMinMax = TextBlockUtils.getMinMax(this, stringBounder);
        }
        return this.cachedMinMax;
    }

    class Cross
    extends UGraphicDelegator {
        private Cross(UGraphic ug) {
            super(ug);
        }

        @Override
        public void draw(UShape shape) {
            if (shape instanceof Ftile) {
                Ftile tile = (Ftile)shape;
                tile.drawU(this);
            } else if (shape instanceof Connection) {
                Connection connection = (Connection)shape;
                Ftile tile1 = connection.getFtile1();
                Ftile tile2 = connection.getFtile2();
                if (tile1 == null || tile2 == null) {
                    return;
                }
                if (tile1.getSwimlaneOut() != tile2.getSwimlaneIn()) {
                    ConnectionCross connectionCross = new ConnectionCross(connection);
                    connectionCross.drawU(this.getUg());
                }
            }
        }

        @Override
        public UGraphic apply(UChange change) {
            return new Cross(this.getUg().apply(change));
        }
    }
}

