/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.ErrorUmlType;
import net.sourceforge.plantuml.PSystemError;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.classdiagram.command.CommandHideShowByGender;
import net.sourceforge.plantuml.classdiagram.command.CommandHideShowByVisibility;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandAffineTransform;
import net.sourceforge.plantuml.command.CommandAffineTransformMultiline;
import net.sourceforge.plantuml.command.CommandCaption;
import net.sourceforge.plantuml.command.CommandControl;
import net.sourceforge.plantuml.command.CommandDecoratorMultine;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandFooter;
import net.sourceforge.plantuml.command.CommandHeader;
import net.sourceforge.plantuml.command.CommandHideUnlinked;
import net.sourceforge.plantuml.command.CommandMinwidth;
import net.sourceforge.plantuml.command.CommandMultilinesFooter;
import net.sourceforge.plantuml.command.CommandMultilinesHeader;
import net.sourceforge.plantuml.command.CommandMultilinesLegend;
import net.sourceforge.plantuml.command.CommandMultilinesTitle;
import net.sourceforge.plantuml.command.CommandNope;
import net.sourceforge.plantuml.command.CommandPragma;
import net.sourceforge.plantuml.command.CommandRotate;
import net.sourceforge.plantuml.command.CommandScale;
import net.sourceforge.plantuml.command.CommandScaleMaxHeight;
import net.sourceforge.plantuml.command.CommandScaleMaxWidth;
import net.sourceforge.plantuml.command.CommandScaleMaxWidthAndHeight;
import net.sourceforge.plantuml.command.CommandScaleWidthAndHeight;
import net.sourceforge.plantuml.command.CommandScaleWidthOrHeight;
import net.sourceforge.plantuml.command.CommandSkinParam;
import net.sourceforge.plantuml.command.CommandSkinParamMultilines;
import net.sourceforge.plantuml.command.CommandSpriteFile;
import net.sourceforge.plantuml.command.CommandTitle;
import net.sourceforge.plantuml.command.FactorySpriteCommand;
import net.sourceforge.plantuml.command.PSystemAbstractFactory;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.utils.StartUtils;
import net.sourceforge.plantuml.version.IteratorCounter2;

public abstract class UmlDiagramFactory
extends PSystemAbstractFactory {
    private final List<Command> cmds = this.createCommands();

    protected UmlDiagramFactory() {
        this(DiagramType.UML);
    }

    protected UmlDiagramFactory(DiagramType type) {
        super(type);
    }

    @Override
    public final Diagram createSystem(UmlSource source) {
        IteratorCounter2 it = source.iterator2();
        CharSequence2 startLine = (CharSequence2)it.next();
        if (!StartUtils.isArobaseStartDiagram(startLine)) {
            throw new UnsupportedOperationException();
        }
        if (source.isEmpty()) {
            return this.buildEmptyError(source, startLine.getLocation());
        }
        AbstractPSystem sys = this.createEmptyDiagram();
        while (it.hasNext()) {
            if (StartUtils.isArobaseEndDiagram(it.peek())) {
                if (sys == null) {
                    return null;
                }
                String err = sys.checkFinalError();
                if (err != null) {
                    return this.buildExecutionError(source, err, it.peek().getLocation());
                }
                if (source.getTotalLineCount() == 2) {
                    return this.buildEmptyError(source, it.peek().getLocation());
                }
                sys.makeDiagramReady();
                if (!sys.isOk()) {
                    return null;
                }
                sys.setSource(source);
                return sys;
            }
            if (!((sys = this.executeFewLines(sys, source, it)) instanceof PSystemError)) continue;
            return sys;
        }
        sys.setSource(source);
        return sys;
    }

    private AbstractPSystem executeFewLines(AbstractPSystem sys, UmlSource source, IteratorCounter2 it) {
        Step step = this.getCandidate(it);
        if (step == null) {
            ErrorUml err = new ErrorUml(ErrorUmlType.SYNTAX_ERROR, "Syntax Error?", it.peek().getLocation());
            return new PSystemError(source, err, null);
        }
        CommandExecutionResult result = sys.executeCommand(step.command, step.blocLines);
        if (!result.isOk()) {
            ErrorUml err = new ErrorUml(ErrorUmlType.EXECUTION_ERROR, result.getError(), ((CharSequence2)step.blocLines.getFirst499()).getLocation());
            sys = new PSystemError(source, err, result.getDebugLines());
        }
        if (result.getNewDiagram() != null) {
            sys = result.getNewDiagram();
        }
        return sys;
    }

    private Step getCandidate(IteratorCounter2 it) {
        BlocLines single = BlocLines.single(it.peek());
        for (Command cmd : this.cmds) {
            IteratorCounter2 cloned;
            BlocLines lines;
            CommandControl result = cmd.isValid(single);
            if (result == CommandControl.OK) {
                it.next();
                return new Step(cmd, single);
            }
            if (result != CommandControl.OK_PARTIAL || (lines = this.isMultilineCommandOk(cloned = it.cloneMe(), cmd)) == null) continue;
            it.copyStateFrom(cloned);
            assert (lines != null);
            return new Step(cmd, lines);
        }
        return null;
    }

    private BlocLines isMultilineCommandOk(IteratorCounter2 it, Command cmd) {
        BlocLines lines = new BlocLines();
        int nb = 0;
        while (it.hasNext()) {
            CommandControl result = cmd.isValid(lines = this.addOneSingleLineManageEmbedded2(it, lines));
            if (result == CommandControl.NOT_OK) {
                return null;
            }
            if (result == CommandControl.OK) {
                return lines;
            }
            if (!(cmd instanceof CommandDecoratorMultine) || ++nb <= ((CommandDecoratorMultine)cmd).getNbMaxLines()) continue;
            return null;
        }
        return null;
    }

    private BlocLines addOneSingleLineManageEmbedded2(IteratorCounter2 it, BlocLines lines) {
        CharSequence linetoBeAdded = (CharSequence)it.next();
        lines = lines.add2(linetoBeAdded);
        if (StringUtils.trinNoTrace(linetoBeAdded).equals("{{")) {
            while (it.hasNext()) {
                CharSequence s = (CharSequence)it.next();
                lines = lines.add2(s);
                if (!StringUtils.trinNoTrace(s).equals("}}")) continue;
                return lines;
            }
        }
        return lines;
    }

    protected abstract List<Command> createCommands();

    public abstract AbstractPSystem createEmptyDiagram();

    protected final void addCommonCommands(List<Command> cmds) {
        cmds.add(new CommandNope());
        cmds.add(new CommandPragma());
        cmds.add(new CommandTitle());
        cmds.add(new CommandCaption());
        cmds.add(new CommandMultilinesTitle());
        cmds.add(new CommandMultilinesLegend());
        cmds.add(new CommandFooter());
        cmds.add(new CommandMultilinesFooter());
        cmds.add(new CommandHeader());
        cmds.add(new CommandMultilinesHeader());
        cmds.add(new CommandSkinParam());
        cmds.add(new CommandSkinParamMultilines());
        cmds.add(new CommandMinwidth());
        cmds.add(new CommandRotate());
        cmds.add(new CommandScale());
        cmds.add(new CommandScaleWidthAndHeight());
        cmds.add(new CommandScaleWidthOrHeight());
        cmds.add(new CommandScaleMaxWidth());
        cmds.add(new CommandScaleMaxHeight());
        cmds.add(new CommandScaleMaxWidthAndHeight());
        cmds.add(new CommandAffineTransform());
        cmds.add(new CommandAffineTransformMultiline());
        cmds.add(new CommandHideUnlinked());
        FactorySpriteCommand factorySpriteCommand = new FactorySpriteCommand();
        cmds.add(factorySpriteCommand.createMultiLine(false));
        cmds.add(factorySpriteCommand.createSingleLine());
        cmds.add(new CommandSpriteFile());
        cmds.add(new CommandHideShowByVisibility());
        cmds.add(new CommandHideShowByGender());
    }

    public final List<String> getDescription() {
        ArrayList<String> result = new ArrayList<String>();
        for (Command cmd : this.createCommands()) {
            result.addAll(Arrays.asList(cmd.getDescription()));
        }
        return Collections.unmodifiableList(result);
    }

    static class Step {
        final Command command;
        final BlocLines blocLines;

        Step(Command command, BlocLines blocLines) {
            this.command = command;
            this.blocLines = blocLines;
        }
    }
}

