/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EmbededDiagram;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SvgString;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.creole.Atom;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UImageSvg;

class AtomEmbededSystem
implements Atom {
    private final List<CharSequence2> lines2;

    public AtomEmbededSystem(EmbededDiagram sys) {
        this.lines2 = sys.getLines().as2();
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return 0.0;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        try {
            BufferedImage im = this.getImage();
            return new Dimension2DDouble(im.getWidth(), im.getHeight());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return new Dimension2DDouble(42.0, 42.0);
    }

    @Override
    public void drawU(UGraphic ug) {
        try {
            boolean isSvg = ug.matchesProperty("SVG");
            if (isSvg) {
                String imageSvg = this.getImageSvg();
                SvgString svg = new SvgString(imageSvg, 1.0);
                ug.draw(new UImageSvg(svg));
                return;
            }
            BufferedImage im = this.getImage();
            UImage image = new UImage(im);
            ug.draw(image);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private String getImageSvg() throws IOException, InterruptedException {
        Diagram system = this.getSystem();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        system.exportDiagram(os, 0, new FileFormatOption(FileFormat.SVG));
        os.close();
        return new String(os.toByteArray());
    }

    private BufferedImage getImage() throws IOException, InterruptedException {
        Diagram system = this.getSystem();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        system.exportDiagram(os, 0, new FileFormatOption(FileFormat.PNG));
        os.close();
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        BufferedImage im = ImageIO.read(is);
        is.close();
        return im;
    }

    private Diagram getSystem() throws IOException, InterruptedException {
        BlockUml blockUml = new BlockUml(this.lines2, 0, Defines.createEmpty());
        return blockUml.getDiagram();
    }
}

