/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SvgString;
import net.sourceforge.plantuml.creole.Atom;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorSimple;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.math.ScientificEquationSafe;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UImageSvg;

public class AtomMath
implements Atom {
    private final double scale;
    private final ScientificEquationSafe math;
    private final HtmlColor foreground;
    private final HtmlColor background;
    private Dimension2D dim;

    public AtomMath(ScientificEquationSafe math, HtmlColor foreground, HtmlColor background, double scale) {
        this.math = math;
        this.foreground = foreground;
        this.background = background;
        this.scale = scale;
    }

    private Dimension2D calculateDimensionSlow(StringBounder stringBounder) {
        BufferedImage image = this.math.getImage(this.scale, Color.BLACK, Color.WHITE);
        return new Dimension2DDouble(image.getWidth(), image.getHeight());
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        if (this.dim == null) {
            this.dim = this.calculateDimensionSlow(stringBounder);
        }
        return this.dim;
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return 0.0;
    }

    @Override
    public void drawU(UGraphic ug) {
        boolean isSvg = ug.matchesProperty("SVG");
        Color back = isSvg && this.background == null ? null : this.getColor(this.background == null ? ug.getParam().getBackcolor() : this.background, Color.WHITE);
        Color fore = this.getColor(this.foreground, Color.BLACK);
        double dpiFactor = ug.dpiFactor();
        if (isSvg) {
            SvgString svg = this.math.getSvg(this.scale, fore, back);
            ug.draw(new UImageSvg(svg));
        } else {
            ug.draw(new UImage(this.math.getImage(this.scale * dpiFactor, fore, back)));
        }
    }

    private Color getColor(HtmlColor color, Color defaultValue) {
        if (color instanceof HtmlColorSimple) {
            return ((HtmlColorSimple)color).getColor999();
        }
        return defaultValue;
    }
}

