/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.descdiagram.command;

import java.util.List;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.descdiagram.command.CommandCreateElementFull;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;

public class CommandCreateElementMultilines
extends CommandMultilines2<AbstractEntityDiagram> {
    private final int type;

    public CommandCreateElementMultilines(int type) {
        super(CommandCreateElementMultilines.getRegexConcat(type), MultilinesStrategy.REMOVE_STARTING_QUOTE);
        this.type = type;
    }

    @Override
    public String getPatternEnd() {
        if (this.type == 0) {
            return "(?i)^(.*)[%g]$";
        }
        if (this.type == 1) {
            return "(?i)^(.*)\\]$";
        }
        throw new IllegalArgumentException();
    }

    private static RegexConcat getRegexConcat(int type) {
        if (type == 0) {
            return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("TYPE", "(artifact|actor|folder|card|file|package|rectangle|node|frame|cloud|database|queue|stack|storage|agent|usecase|component|boundary|control|entity|interface|circle|collections)[%s]+"), new RegexLeaf("CODE", "([\\p{L}0-9_.]+)"), new RegexLeaf("[%s]*"), new RegexLeaf("STEREO", "(\\<\\<.+\\>\\>)?"), new RegexLeaf("[%s]*"), ColorParser.exp1(), new RegexLeaf("[%s]*"), new RegexLeaf("DESC", "as[%s]*[%g]([^%g]*)$"));
        }
        if (type == 1) {
            return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("TYPE", "(artifact|actor|folder|card|file|package|rectangle|node|frame|cloud|database|queue|stack|storage|agent|usecase|component|boundary|control|entity|interface|circle|collections)[%s]+"), new RegexLeaf("CODE", "([\\p{L}0-9_.]+)"), new RegexLeaf("[%s]*"), new RegexLeaf("STEREO", "(\\<\\<.+\\>\\>)?"), new RegexLeaf("[%s]*"), ColorParser.exp1(), new RegexLeaf("[%s]*"), new RegexLeaf("DESC", "\\[(.*)$"));
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected CommandExecutionResult executeNow(AbstractEntityDiagram diagram, BlocLines lines) {
        USymbol usymbol;
        LeafType type;
        lines = lines.trim(false);
        RegexResult line0 = this.getStartingPattern().matcher(StringUtils.trin(lines.getFirst499()));
        String symbol = StringUtils.goUpperCase(line0.get("TYPE", 0));
        if (symbol.equalsIgnoreCase("usecase")) {
            type = LeafType.USECASE;
            usymbol = null;
        } else {
            usymbol = USymbol.getFromString(symbol);
            if (usymbol == null) {
                throw new IllegalStateException();
            }
            type = LeafType.DESCRIPTION;
        }
        Code code = Code.of(line0.get("CODE", 0));
        List<String> lineLast = StringUtils.getSplit(MyPattern.cmpile(this.getPatternEnd()), lines.getLast499().toString());
        lines = lines.subExtract(1, 1);
        Display display = lines.toDisplay();
        String descStart = line0.get("DESC", 0);
        if (StringUtils.isNotEmpty(descStart)) {
            display = display.addFirst(descStart);
        }
        if (StringUtils.isNotEmpty(lineLast.get(0))) {
            display = display.add(lineLast.get(0));
        }
        String stereotype = line0.get("STEREO", 0);
        if (CommandCreateElementFull.existsWithBadType(diagram, code, type, usymbol)) {
            return CommandExecutionResult.error("This element (" + code.getFullName() + ") is already defined");
        }
        ILeaf result = diagram.createLeaf(code, display, type, usymbol);
        if (result == null) {
            return CommandExecutionResult.error("This element (" + code.getFullName() + ") is already defined");
        }
        result.setUSymbol(usymbol);
        if (stereotype != null) {
            result.setStereotype(new Stereotype(stereotype, diagram.getSkinParam().getCircledCharacterRadius(), diagram.getSkinParam().getFont(null, false, FontParam.CIRCLED_CHARACTER), diagram.getSkinParam().getIHtmlColorSet()));
        }
        result.setSpecificColorTOBEREMOVED(ColorType.BACK, diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(line0.get("COLOR", 0)));
        return CommandExecutionResult.ok();
    }

    static enum Mode {
        EXTENDS,
        IMPLEMENTS;

    }
}

