/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.graphic.UGraphicDelegator;
import net.sourceforge.plantuml.ugraphic.CompressionTransform;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class UGraphicCompress2
extends UGraphicDelegator {
    private final CompressionTransform compressionTransform;
    private final UTranslate translate;

    @Override
    public UGraphic apply(UChange change) {
        if (change instanceof UTranslate) {
            return new UGraphicCompress2(this.getUg(), this.compressionTransform, this.translate.compose((UTranslate)change));
        }
        if (change instanceof UStroke || change instanceof UChangeBackColor || change instanceof UChangeColor) {
            return new UGraphicCompress2(this.getUg().apply(change), this.compressionTransform, this.translate);
        }
        throw new UnsupportedOperationException();
    }

    public UGraphicCompress2(UGraphic ug, CompressionTransform compressionTransform) {
        this(ug, compressionTransform, new UTranslate());
    }

    private UGraphicCompress2(UGraphic ug, CompressionTransform compressionTransform, UTranslate translate) {
        super(ug);
        this.compressionTransform = compressionTransform;
        this.translate = translate;
    }

    @Override
    public void draw(UShape shape) {
        double x = this.translate.getDx();
        double y = this.translate.getDy();
        if (shape instanceof ULine) {
            this.drawLine(x, y, (ULine)shape);
        } else if (shape instanceof Snake) {
            this.drawSnake(x, y, (Snake)shape);
        } else {
            this.getUg().apply(new UTranslate(this.ct(x), y)).draw(shape);
        }
    }

    private void drawSnake(double x, double y, Snake shape) {
        Snake transformed = shape.translate(new UTranslate(x, y)).transformX(this.compressionTransform);
        this.getUg().draw(transformed);
    }

    private void drawLine(double x, double y, ULine shape) {
        this.drawLine(this.ct(x), y, this.ct(x + shape.getDX()), y + shape.getDY());
    }

    private double ct(double v) {
        return this.compressionTransform.transform(v);
    }

    private void drawLine(double x1, double y1, double x2, double y2) {
        double xmin = Math.min(x1, x2);
        double xmax = Math.max(x1, x2);
        double ymin = Math.min(y1, y2);
        double ymax = Math.max(y1, y2);
        this.getUg().apply(new UTranslate(xmin, ymin)).draw(new ULine(xmax - xmin, ymax - ymin));
    }
}

