/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import net.sourceforge.plantuml.ugraphic.UShape;

public class UImage
implements UShape {
    private final BufferedImage image;

    public UImage(BufferedImage image) {
        this.image = image;
    }

    public UImage scale(double scale) {
        if (scale == 1.0) {
            return this;
        }
        int w = (int)Math.round((double)this.image.getWidth() * scale);
        int h = (int)Math.round((double)this.image.getHeight() * scale);
        BufferedImage after = new BufferedImage(w, h, this.image.getType());
        AffineTransform at = new AffineTransform();
        at.scale(scale, scale);
        AffineTransformOp scaleOp = new AffineTransformOp(at, 2);
        return new UImage(scaleOp.filter(this.image, after));
    }

    public final BufferedImage getImage() {
        return this.image;
    }

    public double getWidth() {
        return this.image.getWidth() - 1;
    }

    public double getHeight() {
        return this.image.getHeight() - 1;
    }
}

