/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.g2d;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import net.sourceforge.plantuml.EnsureVisible;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UImageSvg;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UShape;

public class DriverImageG2d
implements UDriver<Graphics2D> {
    private final EnsureVisible visible;
    private final double dpiFactor;

    public DriverImageG2d(double dpiFactor, EnsureVisible visible) {
        this.visible = visible;
        this.dpiFactor = dpiFactor;
    }

    @Override
    public void draw(UShape ushape, double x, double y, ColorMapper mapper, UParam param, Graphics2D g2d) {
        if (ushape instanceof UImageSvg) {
            return;
        }
        UImage shape = (UImage)ushape;
        this.visible.ensureVisible(x, y);
        this.visible.ensureVisible(x + shape.getWidth(), y + shape.getHeight());
        AffineTransform back = g2d.getTransform();
        g2d.scale(1.0 / this.dpiFactor, 1.0 / this.dpiFactor);
        g2d.drawImage((Image)shape.getImage(), (int)(x * this.dpiFactor), (int)(y * this.dpiFactor), null);
        g2d.setTransform(back);
    }
}

