/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.hand;

import net.sourceforge.plantuml.ugraphic.Shadowable;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.hand.HandJiggle;

public class URectangleHand {
    private final UPolygon poly;

    public URectangleHand(URectangle rectangle) {
        HandJiggle jiggle;
        double width = rectangle.getWidth();
        double height = rectangle.getHeight();
        double rx = Math.min(rectangle.getRx() / 2.0, width / 2.0);
        double ry = Math.min(rectangle.getRy() / 2.0, height / 2.0);
        if (rx == 0.0 && ry == 0.0) {
            jiggle = new HandJiggle(0.0, 0.0, 1.5);
            jiggle.lineTo(width, 0.0);
            jiggle.lineTo(width, height);
            jiggle.lineTo(0.0, height);
            jiggle.lineTo(0.0, 0.0);
        } else {
            jiggle = new HandJiggle(rx, 0.0, 1.5);
            jiggle.lineTo(width - rx, 0.0);
            jiggle.arcTo(-1.5707963267948966, 0.0, width - rx, ry, rx, ry);
            jiggle.lineTo(width, height - ry);
            jiggle.arcTo(0.0, 1.5707963267948966, width - rx, height - ry, rx, ry);
            jiggle.lineTo(rx, height);
            jiggle.arcTo(1.5707963267948966, Math.PI, rx, height - ry, rx, ry);
            jiggle.lineTo(0.0, ry);
            jiggle.arcTo(Math.PI, 4.71238898038469, rx, ry, rx, ry);
        }
        this.poly = jiggle.toUPolygon();
        this.poly.setDeltaShadow(rectangle.getDeltaShadow());
    }

    public Shadowable getHanddrawn() {
        return this.poly;
    }
}

