/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.StringLocated;

public class LineLocationImpl
implements LineLocation {
    private final String desc;
    private final int position;
    private final LineLocation parent;

    public String toString() {
        return this.desc + " : " + this.position;
    }

    public LineLocationImpl(String desc, LineLocation parent) {
        this(desc, parent, -1);
    }

    private LineLocationImpl(String desc, LineLocation parent, int position) {
        if (desc == null) {
            throw new IllegalArgumentException();
        }
        this.parent = parent;
        this.desc = desc;
        this.position = position;
    }

    public LineLocationImpl oneLineRead() {
        return new LineLocationImpl(this.desc, this.parent, this.position + 1);
    }

    public static LineLocation fromLine(CharSequence cs) {
        if (cs instanceof StringLocated) {
            return ((StringLocated)((Object)cs)).getLocation();
        }
        return null;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public LineLocation getParent() {
        return this.parent;
    }

    private boolean isStandardLibrary() {
        return this.desc.startsWith("<");
    }

    @Override
    public int compareTo(LineLocation other) {
        LineLocationImpl other2 = (LineLocationImpl)other;
        if (this.isStandardLibrary() && !other2.isStandardLibrary()) {
            return -1;
        }
        if (!this.isStandardLibrary() && other2.isStandardLibrary()) {
            return 1;
        }
        return this.position - other2.position;
    }
}

