/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.InstructionList;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileKilled;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteType;

public class InstructionRepeat
implements Instruction {
    private final InstructionList repeatList = new InstructionList();
    private final Instruction parent;
    private final LinkRendering nextLinkRenderer;
    private final Swimlane swimlane;
    private final HtmlColor color;
    private boolean killed = false;
    private Display backward = Display.NULL;
    private Display test = Display.NULL;
    private Display yes = Display.NULL;
    private Display out = Display.NULL;
    private final Display startLabel;
    private boolean testCalled = false;
    private LinkRendering endRepeatLinkRendering = LinkRendering.none();
    private LinkRendering backRepeatLinkRendering = LinkRendering.none();

    @Override
    public boolean containsBreak() {
        return this.repeatList.containsBreak();
    }

    public InstructionRepeat(Swimlane swimlane, Instruction parent, LinkRendering nextLinkRenderer, HtmlColor color, Display startLabel) {
        this.startLabel = startLabel;
        this.parent = parent;
        this.swimlane = swimlane;
        this.nextLinkRenderer = nextLinkRenderer;
        if (nextLinkRenderer == null) {
            throw new IllegalArgumentException();
        }
        this.color = color;
    }

    private boolean isLastOfTheParent() {
        if (this.parent instanceof InstructionList) {
            return ((InstructionList)this.parent).getLast() == this;
        }
        return false;
    }

    public void setBackward(Display label) {
        this.backward = label;
    }

    @Override
    public void add(Instruction ins) {
        this.repeatList.add(ins);
    }

    @Override
    public Ftile createFtile(FtileFactory factory) {
        Ftile back = Display.isNull(this.backward) ? null : factory.activity(this.backward, this.swimlane, BoxStyle.PLAIN, Colors.empty());
        Ftile result = factory.repeat(this.swimlane, this.repeatList.getSwimlaneOut(), this.startLabel, factory.decorateOut(this.repeatList.createFtile(factory), this.endRepeatLinkRendering), this.test, this.yes, this.out, this.color, this.backRepeatLinkRendering, back, this.isLastOfTheParent());
        if (this.killed) {
            return new FtileKilled(result);
        }
        return result;
    }

    public Instruction getParent() {
        return this.parent;
    }

    public void setTest(Display test, Display yes, Display out, LinkRendering endRepeatLinkRendering, LinkRendering backRepeatLinkRendering) {
        this.test = test;
        this.yes = yes;
        this.out = out;
        if (test == null) {
            throw new IllegalArgumentException();
        }
        if (yes == null) {
            throw new IllegalArgumentException();
        }
        if (out == null) {
            throw new IllegalArgumentException();
        }
        this.endRepeatLinkRendering = endRepeatLinkRendering;
        this.backRepeatLinkRendering = backRepeatLinkRendering;
        this.testCalled = true;
    }

    @Override
    public final boolean kill() {
        if (this.testCalled) {
            this.killed = true;
            return true;
        }
        return this.repeatList.kill();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.nextLinkRenderer;
    }

    @Override
    public boolean addNote(Display note, NotePosition position, NoteType type, Colors colors, Swimlane swimlaneNote) {
        return this.repeatList.addNote(note, position, type, colors, swimlaneNote);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.repeatList.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.parent.getSwimlaneOut();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.parent.getSwimlaneOut();
    }
}

