/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram;

import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.classdiagram.FullLayout;
import net.sourceforge.plantuml.classdiagram.RowLayout;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.objectdiagram.AbstractClassOrObjectDiagram;
import net.sourceforge.plantuml.svek.image.EntityImageClass;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;

public class ClassDiagram
extends AbstractClassOrObjectDiagram {
    private boolean allowMixing;
    private int useLayoutExplicit = 0;

    private final String getNamespace(Code fullyCode) {
        return this.getNamespace(fullyCode, fullyCode.getSeparator());
    }

    private final String getNamespace(Code fullyCode, String separator) {
        int x;
        String name = fullyCode.getFullName();
        if (separator == null) {
            throw new IllegalArgumentException(this.toString());
        }
        do {
            if ((x = name.lastIndexOf(separator)) != -1) continue;
            return null;
        } while (this.entityFactory.getLeafsget(Code.of(name = name.substring(0, x), separator)) != null);
        return name;
    }

    public final Code getShortName(Code code) {
        String separator = code.getSeparator();
        if (separator == null) {
            throw new IllegalArgumentException();
        }
        String codeString = code.getFullName();
        String namespace = this.getNamespace(code);
        if (namespace == null) {
            return Code.of(codeString, separator);
        }
        return Code.of(codeString.substring(namespace.length() + separator.length()), separator);
    }

    @Override
    public ILeaf getOrCreateLeaf(Code code, LeafType type, USymbol symbol) {
        if (this.getNamespaceSeparator() != null) {
            code = code.withSeparator(this.getNamespaceSeparator());
        }
        if (type == null) {
            code = code.eventuallyRemoveStartingAndEndingDoubleQuote("\"([:");
            if (this.getNamespaceSeparator() == null) {
                return this.getOrCreateLeafDefault(code, LeafType.CLASS, symbol);
            }
            if (super.leafExist(code = this.getFullyQualifiedCode(code))) {
                return this.getOrCreateLeafDefault(code, LeafType.CLASS, symbol);
            }
            return this.createEntityWithNamespace(code, Display.getWithNewlines(this.getShortName(code)), LeafType.CLASS, symbol);
        }
        if (this.getNamespaceSeparator() == null) {
            return this.getOrCreateLeafDefault(code, type, symbol);
        }
        if (super.leafExist(code = this.getFullyQualifiedCode(code))) {
            return this.getOrCreateLeafDefault(code, type, symbol);
        }
        return this.createEntityWithNamespace(code, Display.getWithNewlines(this.getShortName(code)), type, symbol);
    }

    @Override
    public ILeaf createLeaf(Code code, Display display, LeafType type, USymbol symbol) {
        if (this.getNamespaceSeparator() != null) {
            code = code.withSeparator(this.getNamespaceSeparator());
        }
        if (type != LeafType.ABSTRACT_CLASS && type != LeafType.ANNOTATION && type != LeafType.CLASS && type != LeafType.INTERFACE && type != LeafType.ENUM && type != LeafType.LOLLIPOP_FULL && type != LeafType.LOLLIPOP_HALF && type != LeafType.NOTE) {
            return super.createLeaf(code, display, type, symbol);
        }
        if (this.getNamespaceSeparator() == null) {
            return super.createLeaf(code, display, type, symbol);
        }
        if (super.leafExist(code = this.getFullyQualifiedCode(code))) {
            throw new IllegalArgumentException("Already known: " + code);
        }
        return this.createEntityWithNamespace(code, display, type, symbol);
    }

    private ILeaf createEntityWithNamespace(Code fullyCode, Display display, LeafType type, USymbol symbol) {
        IGroup backupCurrentGroup;
        IGroup group = backupCurrentGroup = this.getCurrentGroup();
        String namespace = this.getNamespace(fullyCode, this.getNamespaceSeparator());
        if (namespace != null && (EntityUtils.groupRoot(group) || !group.getCode().getFullName().equals(namespace))) {
            Code namespace2 = Code.of(namespace);
            this.gotoGroupInternal(namespace2, Display.getWithNewlines(namespace), namespace2, GroupType.PACKAGE, this.getRootGroup());
        }
        ILeaf result = this.createLeafInternal(fullyCode, Display.isNull(display) ? Display.getWithNewlines(this.getShortName(fullyCode)).withCreoleMode(CreoleMode.SIMPLE_LINE) : display, type, symbol);
        this.gotoThisGroup(backupCurrentGroup);
        return result;
    }

    @Override
    public final boolean leafExist(Code code) {
        if (this.getNamespaceSeparator() == null) {
            return super.leafExist(code);
        }
        code = code.withSeparator(this.getNamespaceSeparator());
        return super.leafExist(this.getFullyQualifiedCode(code));
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.CLASS;
    }

    public void setAllowMixing(boolean allowMixing) {
        this.allowMixing = allowMixing;
    }

    public boolean isAllowMixing() {
        return this.allowMixing;
    }

    public void layoutNewLine() {
        ++this.useLayoutExplicit;
        this.incRawLayout();
    }

    @Override
    protected final ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        if (this.useLayoutExplicit != 0) {
            return this.exportLayoutExplicit(os, index, fileFormatOption);
        }
        return super.exportDiagramInternal(os, index, fileFormatOption);
    }

    protected final ImageData exportLayoutExplicit(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        FullLayout fullLayout = new FullLayout();
        for (int i = 0; i <= this.useLayoutExplicit; ++i) {
            RowLayout rawLayout = this.getRawLayout(i);
            fullLayout.addRowLayout(rawLayout);
        }
        ImageBuilder imageBuilder = new ImageBuilder(this.getSkinParam(), 1.0, null, null, 0.0, 10.0, null);
        imageBuilder.setUDrawable(fullLayout);
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption, this.seed(), os);
    }

    private RowLayout getRawLayout(int raw) {
        RowLayout rawLayout = new RowLayout();
        for (ILeaf leaf : this.entityFactory.getLeafsvalues()) {
            if (leaf.getRawLayout() != raw) continue;
            rawLayout.addLeaf(this.getEntityImageClass(leaf));
        }
        return rawLayout;
    }

    private TextBlock getEntityImageClass(ILeaf entity) {
        return new EntityImageClass(null, entity, this.getSkinParam(), this);
    }

    @Override
    public String checkFinalError() {
        for (Link link : this.getLinks()) {
            int len = link.getLength();
            if (len != 1) continue;
            for (Link link2 : this.getLinks()) {
                if (!link2.sameConnections(link) || link2.getLength() == 1) continue;
                link2.setLength(1);
            }
        }
        this.applySingleStrategy();
        return super.checkFinalError();
    }
}

