/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandControl;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.core.Diagram;

public abstract class CommandMultilines2<S extends Diagram>
implements Command<S> {
    private final RegexConcat starting;
    private final MultilinesStrategy strategy;

    public CommandMultilines2(RegexConcat patternStart, MultilinesStrategy strategy) {
        if (!patternStart.getPattern().startsWith("^") || !patternStart.getPattern().endsWith("$")) {
            throw new IllegalArgumentException("Bad pattern " + patternStart.getPattern());
        }
        this.strategy = strategy;
        this.starting = patternStart;
    }

    public boolean syntaxWithFinalBracket() {
        return false;
    }

    public abstract String getPatternEnd();

    @Override
    public String[] getDescription() {
        return new String[]{"START: " + this.starting.getPattern(), "END: " + this.getPatternEnd()};
    }

    @Override
    public final CommandControl isValid(BlocLines lines) {
        StringLocated first;
        lines = lines.cleanList2(this.strategy);
        if (this.isCommandForbidden()) {
            return CommandControl.NOT_OK;
        }
        if (this.syntaxWithFinalBracket()) {
            if (lines.size() == 1 && !lines.getFirst499().getStringTrimmed().endsWith("{")) {
                String vline = lines.get499(0).getString() + " {";
                if (this.isValid(BlocLines.singleString(vline)) == CommandControl.OK_PARTIAL) {
                    return CommandControl.OK_PARTIAL;
                }
                return CommandControl.NOT_OK;
            }
            lines = lines.eventuallyMoveBracket();
        }
        if ((first = lines.getFirst499()) == null) {
            return CommandControl.NOT_OK;
        }
        boolean result1 = this.starting.match(first.getStringTrimmed());
        if (!result1) {
            return CommandControl.NOT_OK;
        }
        if (lines.size() == 1) {
            return CommandControl.OK_PARTIAL;
        }
        Matcher2 m1 = MyPattern.cmpile(this.getPatternEnd()).matcher(StringUtils.trinNoTrace(lines.getLast499().getString()));
        if (!m1.matches()) {
            return CommandControl.OK_PARTIAL;
        }
        this.actionIfCommandValid();
        return CommandControl.OK;
    }

    @Override
    public final CommandExecutionResult execute(S system, BlocLines lines) {
        lines = lines.cleanList2(this.strategy);
        if (this.syntaxWithFinalBracket()) {
            lines = lines.eventuallyMoveBracket();
        }
        return this.executeNow(system, lines);
    }

    protected abstract CommandExecutionResult executeNow(S var1, BlocLines var2);

    protected boolean isCommandForbidden() {
        return false;
    }

    protected void actionIfCommandValid() {
    }

    protected final RegexConcat getStartingPattern() {
        return this.starting;
    }
}

