/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandControl;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.core.Diagram;

public abstract class CommandMultilines3<S extends Diagram>
implements Command<S> {
    private final RegexConcat starting;
    private final MultilinesStrategy strategy;

    public CommandMultilines3(RegexConcat patternStart, MultilinesStrategy strategy) {
        if (!patternStart.getPattern().startsWith("^") || !patternStart.getPattern().endsWith("$")) {
            throw new IllegalArgumentException("Bad pattern " + patternStart.getPattern());
        }
        this.strategy = strategy;
        this.starting = patternStart;
    }

    public abstract RegexConcat getPatternEnd2();

    @Override
    public String[] getDescription() {
        return new String[]{"START: " + this.starting.getPattern(), "END: " + this.getPatternEnd2().getPattern()};
    }

    @Override
    public final CommandControl isValid(BlocLines lines) {
        lines = lines.cleanList2(this.strategy);
        if (this.isCommandForbidden()) {
            return CommandControl.NOT_OK;
        }
        StringLocated first = lines.getFirst499();
        if (first == null) {
            return CommandControl.NOT_OK;
        }
        boolean result1 = this.starting.match(first.getStringTrimmed());
        if (!result1) {
            return CommandControl.NOT_OK;
        }
        if (lines.size() == 1) {
            return CommandControl.OK_PARTIAL;
        }
        String potentialLast = StringUtils.trinNoTrace(lines.getLast499().getString());
        boolean m1 = this.getPatternEnd2().match(potentialLast);
        if (!m1) {
            return CommandControl.OK_PARTIAL;
        }
        this.actionIfCommandValid();
        return CommandControl.OK;
    }

    @Override
    public final CommandExecutionResult execute(S system, BlocLines lines) {
        lines = lines.cleanList2(this.strategy);
        return this.executeNow(system, lines);
    }

    protected abstract CommandExecutionResult executeNow(S var1, BlocLines var2);

    protected boolean isCommandForbidden() {
        return false;
    }

    protected void actionIfCommandValid() {
    }

    protected final RegexConcat getStartingPattern() {
        return this.starting;
    }
}

