/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.regex;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MatcherIterator;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.command.regex.RegexPartialMatch;
import net.sourceforge.plantuml.command.regex.RegexResult;

public abstract class RegexComposed
implements IRegex {
    private final List<IRegex> partials;

    protected abstract Pattern2 getFull();

    public RegexComposed(IRegex ... partial) {
        this.partials = Arrays.asList(partial);
    }

    @Override
    public Map<String, RegexPartialMatch> createPartialMatch(Iterator<String> it) {
        HashMap<String, RegexPartialMatch> result = new HashMap<String, RegexPartialMatch>();
        for (IRegex r : this.partials) {
            result.putAll(r.createPartialMatch(it));
        }
        return result;
    }

    @Override
    public final int count() {
        int cpt = this.getStartCount();
        for (IRegex r : this.partials) {
            cpt += r.count();
        }
        return cpt;
    }

    protected int getStartCount() {
        return 0;
    }

    public RegexResult matcher(String s) {
        Matcher2 matcher = this.getFull().matcher(s);
        if (!matcher.find()) {
            return null;
        }
        MatcherIterator it = new MatcherIterator(matcher);
        return new RegexResult(this.createPartialMatch(it));
    }

    public final boolean match(String s) {
        return this.getFull().matcher(s).find();
    }

    @Override
    public final String getPattern() {
        return this.getFull().pattern();
    }

    protected final List<IRegex> getPartials() {
        return this.partials;
    }
}

