/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.descdiagram.command;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.descdiagram.DescriptionDiagram;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;

public class CommandCreateElementFull
extends SingleLineCommand2<DescriptionDiagram> {
    public static final String ALL_TYPES = "artifact|actor|folder|card|file|package|rectangle|node|frame|cloud|database|queue|stack|storage|agent|usecase|component|boundary|control|entity|interface|circle|collections";
    private static final String CODE_CORE = "[\\p{L}0-9_.]+|\\(\\)[%s]*[\\p{L}0-9_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\]";
    public static final String CODE = "([\\p{L}0-9_.]+|\\(\\)[%s]*[\\p{L}0-9_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\])";
    public static final String CODE_WITH_QUOTE = "([\\p{L}0-9_.]+|\\(\\)[%s]*[\\p{L}0-9_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\]|[%g].+?[%g])";
    private static final String DISPLAY_CORE = "[%g].+?[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\]";
    public static final String DISPLAY = "([%g].+?[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\])";
    public static final String DISPLAY_WITHOUT_QUOTE = "([%g].+?[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\]|[\\p{L}0-9_.]+)";

    public CommandCreateElementFull() {
        super(CommandCreateElementFull.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("SYMBOL", "(?:(artifact|actor|folder|card|file|package|rectangle|node|frame|cloud|database|queue|stack|storage|agent|usecase|component|boundary|control|entity|interface|circle|collections|\\(\\))[%s]+)?"), CommandCreateElementFull.color2().getRegex(), new RegexLeaf("[%s]*"), new RegexOr(new RegexLeaf("CODE1", CODE_WITH_QUOTE), new RegexConcat(new RegexLeaf("DISPLAY2", DISPLAY), new RegexLeaf("STEREOTYPE2", "(?:[%s]+(\\<\\<.+\\>\\>))?"), new RegexLeaf("[%s]*as[%s]+"), new RegexLeaf("CODE2", CODE)), new RegexConcat(new RegexLeaf("CODE3", CODE), new RegexLeaf("STEREOTYPE3", "(?:[%s]+(\\<\\<.+\\>\\>))?"), new RegexLeaf("[%s]+as[%s]*"), new RegexLeaf("DISPLAY3", DISPLAY)), new RegexConcat(new RegexLeaf("DISPLAY4", DISPLAY_WITHOUT_QUOTE), new RegexLeaf("STEREOTYPE4", "(?:[%s]+(\\<\\<.+\\>\\>))?"), new RegexLeaf("[%s]*as[%s]+"), new RegexLeaf("CODE4", CODE))), new RegexLeaf("STEREOTYPE", "(?:[%s]*(\\<\\<.+\\>\\>))?"), new RegexLeaf("[%s]*"), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("[%s]*"), CommandCreateElementFull.color().getRegex(), new RegexLeaf("$"));
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    private static ColorParser color2() {
        return ColorParser.simpleColor(ColorType.BACK, "COLOR2");
    }

    @Override
    protected final boolean isForbidden(CharSequence line) {
        return line.toString().matches("^[\\p{L}0-9_.]+$");
    }

    @Override
    protected CommandExecutionResult executeArg(DescriptionDiagram diagram, LineLocation location, RegexResult arg) {
        String urlString;
        USymbol usymbol;
        LeafType type;
        String symbol;
        String codeRaw = arg.getLazzy("CODE", 0);
        String displayRaw = arg.getLazzy("DISPLAY", 0);
        char codeChar = this.getCharEncoding(codeRaw);
        char codeDisplay = this.getCharEncoding(displayRaw);
        if (codeRaw.startsWith("()")) {
            symbol = "interface";
            codeRaw = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(codeRaw.substring(2)));
        } else {
            symbol = codeChar == '(' || codeDisplay == '(' ? "usecase" : (codeChar == ':' || codeDisplay == ':' ? "actor" : (codeChar == '[' || codeDisplay == '[' ? "component" : arg.get("SYMBOL", 0)));
        }
        if (symbol == null) {
            type = LeafType.DESCRIPTION;
            usymbol = USymbol.ACTOR;
        } else if (symbol.equalsIgnoreCase("usecase")) {
            type = LeafType.USECASE;
            usymbol = null;
        } else if (symbol.equalsIgnoreCase("circle")) {
            type = LeafType.CIRCLE;
            usymbol = null;
        } else {
            type = LeafType.DESCRIPTION;
            usymbol = USymbol.getFromString(symbol, diagram.getSkinParam().useUml2ForComponent());
            if (usymbol == null) {
                throw new IllegalStateException();
            }
        }
        Code code = Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(codeRaw));
        if (diagram.isGroup(code)) {
            return CommandExecutionResult.error("This element (" + code.getFullName() + ") is already defined");
        }
        String display = displayRaw;
        if (display == null) {
            display = code.getFullName();
        }
        display = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(display);
        String stereotype = arg.getLazzy("STEREOTYPE", 0);
        if (CommandCreateElementFull.existsWithBadType(diagram, code, type, usymbol)) {
            return CommandExecutionResult.error("This element (" + code.getFullName() + ") is already defined");
        }
        ILeaf entity = diagram.getOrCreateLeaf(code, type, usymbol);
        entity.setDisplay(Display.getWithNewlines(display));
        entity.setUSymbol(usymbol);
        if (stereotype != null) {
            entity.setStereotype(new Stereotype(stereotype, diagram.getSkinParam().getCircledCharacterRadius(), diagram.getSkinParam().getFont(null, false, FontParam.CIRCLED_CHARACTER), diagram.getSkinParam().getIHtmlColorSet()));
        }
        if ((urlString = arg.get("URL", 0)) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            Url url = urlBuilder.getUrl(urlString);
            entity.addUrl(url);
        }
        Colors colors = CommandCreateElementFull.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet());
        HtmlColor lineColor = diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(arg.get("LINECOLOR", 1));
        if (lineColor != null) {
            colors = colors.add(ColorType.LINE, lineColor);
        }
        entity.setColors(colors);
        return CommandExecutionResult.ok();
    }

    public static boolean existsWithBadType(AbstractEntityDiagram diagram, Code code, LeafType type, USymbol usymbol) {
        if (!diagram.leafExist(code)) {
            return false;
        }
        ILeaf other = diagram.getLeafsget(code);
        if (other.getLeafType() != type) {
            return true;
        }
        return usymbol != null && other.getUSymbol() != usymbol;
    }

    private char getCharEncoding(String codeRaw) {
        return codeRaw != null && codeRaw.length() > 2 ? codeRaw.charAt(0) : (char)'\u0000';
    }
}

