/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.help;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.graphic.HtmlColorSetSimple;
import net.sourceforge.plantuml.help.Help;

public class CommandHelpColor
extends SingleLineCommand2<Help> {
    public CommandHelpColor() {
        super(CommandHelpColor.getRegexConcat());
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("help"), new RegexLeaf("[%s]+"), new RegexLeaf("colors?"), new RegexLeaf("$"));
    }

    @Override
    protected CommandExecutionResult executeArg(Help diagram, LineLocation location, RegexResult arg) {
        diagram.add("<b>Help on colors");
        diagram.add(" ");
        diagram.add("The code of this command is located in <i>net.sourceforge.plantuml.help</i> package.");
        diagram.add("You may improve it on <i>https://github.com/plantuml/plantuml/tree/master/src/net/sourceforge/plantuml/help</i>");
        diagram.add(" ");
        diagram.add(" The possible colors are :");
        for (String type : new HtmlColorSetSimple().names()) {
            diagram.add("* " + type);
        }
        return CommandExecutionResult.ok();
    }
}

