/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.mindmap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.mindmap.IdeaShape;

class Idea {
    private final Display label;
    private final int level;
    private final Idea parent;
    private final List<Idea> children = new ArrayList<Idea>();
    private final IdeaShape shape;

    public Idea(Display label, IdeaShape shape) {
        this(0, null, label, shape);
    }

    public Idea createIdea(int newLevel, Display newDisplay, IdeaShape newShape) {
        Idea result = new Idea(newLevel, this, newDisplay, newShape);
        this.children.add(result);
        return result;
    }

    private Idea(int level, Idea parent, Display label, IdeaShape shape) {
        this.label = label;
        this.level = level;
        this.parent = parent;
        this.shape = shape;
    }

    public String toString() {
        return this.label.toString();
    }

    public final int getLevel() {
        return this.level;
    }

    public final Display getLabel() {
        return this.label;
    }

    public Collection<Idea> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public Idea getParent() {
        return this.parent;
    }

    public final IdeaShape getShape() {
        return this.shape;
    }
}

