/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.mindmap;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.AnnotatedWorker;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Scale;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.mindmap.Finger;
import net.sourceforge.plantuml.mindmap.FingerImpl2;
import net.sourceforge.plantuml.mindmap.Idea;
import net.sourceforge.plantuml.mindmap.IdeaShape;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class MindMapDiagram
extends UmlDiagram {
    private Branch left = new Branch();
    private Branch right = new Branch();
    private Direction defaultDirection = Direction.RIGHT;

    public final void setDefaultDirection(Direction defaultDirection) {
        this.defaultDirection = defaultDirection;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("MindMap");
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.MINDMAP;
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        Scale scale = this.getScale();
        double dpiFactor = scale == null ? this.getScaleCoef(fileFormatOption) : scale.getScale(100.0, 100.0);
        ISkinParam skinParam = this.getSkinParam();
        ImageBuilder imageBuilder = new ImageBuilder(skinParam.getColorMapper(), dpiFactor, skinParam.getBackgroundColor(), "", "", 10.0, 10.0, null, skinParam.handwritten());
        TextBlockBackcolored result = this.getTextBlock();
        result = new AnnotatedWorker(this, skinParam, fileFormatOption.getDefaultStringBounder()).addAdd(result);
        imageBuilder.setUDrawable(result);
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption, this.seed(), os);
    }

    private TextBlockBackcolored getTextBlock() {
        return new TextBlockBackcolored(){

            @Override
            public void drawU(UGraphic ug) {
                MindMapDiagram.this.drawMe(ug);
            }

            @Override
            public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
                return null;
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                MindMapDiagram.this.computeFinger();
                double y1 = MindMapDiagram.this.right.finger == null ? 0.0 : MindMapDiagram.this.right.finger.getFullThickness(stringBounder) / 2.0;
                double y2 = MindMapDiagram.this.left.finger == null ? 0.0 : MindMapDiagram.this.left.finger.getFullThickness(stringBounder) / 2.0;
                double y = Math.max(y1, y2);
                double x = MindMapDiagram.this.left.finger == null ? 0.0 : MindMapDiagram.this.left.finger.getFullElongation(stringBounder);
                double width = MindMapDiagram.this.right.finger == null ? x : x + MindMapDiagram.this.right.finger.getFullElongation(stringBounder);
                double height = y + Math.max(MindMapDiagram.this.left.finger == null ? 0.0 : MindMapDiagram.this.left.finger.getFullThickness(stringBounder) / 2.0, MindMapDiagram.this.right.finger == null ? 0.0 : MindMapDiagram.this.right.finger.getFullThickness(stringBounder) / 2.0);
                return new Dimension2DDouble(width, height);
            }

            @Override
            public MinMax getMinMax(StringBounder stringBounder) {
                throw new UnsupportedOperationException();
            }

            @Override
            public HtmlColor getBackcolor() {
                return null;
            }
        };
    }

    private void drawMe(UGraphic ug) {
        double x;
        this.computeFinger();
        StringBounder stringBounder = ug.getStringBounder();
        double y1 = this.right.finger == null ? 0.0 : this.right.finger.getFullThickness(stringBounder) / 2.0;
        double y2 = this.left.finger == null ? 0.0 : this.left.finger.getFullThickness(stringBounder) / 2.0;
        double y = Math.max(y1, y2);
        double d = x = this.left.finger == null ? 0.0 : this.left.finger.getFullElongation(stringBounder) + ((FingerImpl2)this.left.finger).getX12();
        if (this.right.finger != null) {
            this.right.finger.drawU(ug.apply(new UTranslate(x, y)));
        }
        if (this.left.finger != null) {
            this.left.finger.drawU(ug.apply(new UTranslate(x, y)));
        }
    }

    private void computeFinger() {
        if (this.left.finger == null && this.right.finger == null) {
            if (this.left.root.hasChildren()) {
                this.left.finger = FingerImpl2.build(this.left.root, this.getSkinParam(), Direction.LEFT);
            }
            if (this.left.finger == null || this.right.root.hasChildren()) {
                this.right.finger = FingerImpl2.build(this.right.root, this.getSkinParam(), Direction.RIGHT);
            }
            if (this.left.finger != null && this.right.finger != null) {
                this.left.finger.doNotDrawFirstPhalanx();
            }
        }
    }

    public CommandExecutionResult addIdea(int level, String label, IdeaShape shape) {
        return this.addIdea(level, label, shape, this.defaultDirection);
    }

    public CommandExecutionResult addIdea(int level, String label, IdeaShape shape, Direction direction) {
        if (level == 0) {
            if (this.right.root != null) {
                return CommandExecutionResult.error("I don't know how to draw multi-root diagram. You should suggest an image so that the PlantUML team implements it :-)");
            }
            this.right.initRoot(label, shape);
            this.left.initRoot(label, shape);
            return CommandExecutionResult.ok();
        }
        if (direction == Direction.LEFT) {
            return this.left.add(level, label, shape);
        }
        return this.right.add(level, label, shape);
    }

    static class Branch {
        private Idea root;
        private Idea last;
        private Finger finger;

        Branch() {
        }

        private void initRoot(String label, IdeaShape shape) {
            this.last = this.root = new Idea(Display.getWithNewlines(label), shape);
        }

        private Idea getParentOfLast(int nb) {
            Idea result = this.last;
            for (int i = 0; i < nb; ++i) {
                result = result.getParent();
            }
            return result;
        }

        private CommandExecutionResult add(int level, String label, IdeaShape shape) {
            if (level == this.last.getLevel() + 1) {
                Idea newIdea;
                this.last = newIdea = this.last.createIdea(level, Display.getWithNewlines(label), shape);
                return CommandExecutionResult.ok();
            }
            if (level <= this.last.getLevel()) {
                Idea newIdea;
                int diff = this.last.getLevel() - level + 1;
                this.last = newIdea = this.getParentOfLast(diff).createIdea(level, Display.getWithNewlines(label), shape);
                return CommandExecutionResult.ok();
            }
            return CommandExecutionResult.error("error42L");
        }
    }
}

