/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.project3.Complement;
import net.sourceforge.plantuml.project3.ComplementEmpty;
import net.sourceforge.plantuml.project3.ComplementPattern;
import net.sourceforge.plantuml.project3.Failable;
import net.sourceforge.plantuml.project3.GanttDiagram;
import net.sourceforge.plantuml.project3.Subject;
import net.sourceforge.plantuml.project3.SubjectPattern;
import net.sourceforge.plantuml.project3.Verb;
import net.sourceforge.plantuml.project3.VerbPattern;

public class NaturalCommand
extends SingleLineCommand2<GanttDiagram> {
    private final SubjectPattern subjectPattern;
    private final VerbPattern verbPattern;
    private final ComplementPattern complementPattern;

    private NaturalCommand(RegexConcat pattern, SubjectPattern subject, VerbPattern verb, ComplementPattern complement) {
        super(pattern);
        this.subjectPattern = subject;
        this.verbPattern = verb;
        this.complementPattern = complement;
    }

    public String toString() {
        return this.subjectPattern.toString() + " " + this.verbPattern.toString() + " " + this.complementPattern.toString();
    }

    @Override
    protected CommandExecutionResult executeArg(GanttDiagram system, LineLocation location, RegexResult arg) {
        Subject subject = this.subjectPattern.getSubject(system, arg);
        Verb verb = this.verbPattern.getVerb(system, arg);
        Failable<Complement> complement = this.complementPattern.getComplement(system, arg, "0");
        if (complement.isFail()) {
            return CommandExecutionResult.error(complement.getError());
        }
        return verb.execute(subject, complement.get());
    }

    public static Command create(SubjectPattern subject, VerbPattern verb, ComplementPattern complement) {
        RegexConcat pattern = complement instanceof ComplementEmpty ? new RegexConcat(new RegexLeaf("^"), subject.toRegex(), new RegexLeaf("[%s]+"), verb.toRegex(), new RegexLeaf("$")) : new RegexConcat(new RegexLeaf("^"), subject.toRegex(), new RegexLeaf("[%s]+"), verb.toRegex(), new RegexLeaf("[%s]+"), complement.toRegex("0"), new RegexLeaf("$"));
        return new NaturalCommand(pattern, subject, verb, complement);
    }
}

