/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.sequencediagram.Delay;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.ParticipantEnglober;
import net.sourceforge.plantuml.sequencediagram.ParticipantType;
import net.sourceforge.plantuml.sequencediagram.teoz.EventsHistory;
import net.sourceforge.plantuml.sequencediagram.teoz.EventsHistoryMode;
import net.sourceforge.plantuml.sequencediagram.teoz.LiveBoxes;
import net.sourceforge.plantuml.sequencediagram.teoz.MutingLine;
import net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class LivingSpace {
    private final Participant p;
    private final Rose skin;
    private final ISkinParam skinParam;
    private final ComponentType headType;
    private final ComponentType tailType;
    private final boolean useContinueLineBecauseOfDelay;
    private final MutingLine mutingLine;
    private final Rose rose = new Rose();
    private final LiveBoxes liveBoxes;
    private final Real posB;
    private Real posC;
    private Real posD;
    private final EventsHistory eventsHistory;
    private boolean create = false;
    private double createY = 0.0;
    private final ParticipantEnglober englober;

    public int getLevelAt(Tile tile, EventsHistoryMode mode) {
        return this.eventsHistory.getLevelAt(tile.getEvent(), mode);
    }

    public void addStepForLivebox(Event event, double y) {
        this.eventsHistory.addStepForLivebox(event, y);
    }

    public String toString() {
        return this.p.getCode() + " B=" + this.posB.getCurrentValue() + "/C=" + LivingSpace.currentValue(this.posC) + "/D=" + LivingSpace.currentValue(this.posD);
    }

    private static String currentValue(Real pos) {
        if (pos == null) {
            return null;
        }
        return "" + pos.getCurrentValue();
    }

    public LivingSpace(Participant p, ParticipantEnglober englober, Rose skin, ISkinParam skinParam, Real position, List<Event> events) {
        this.eventsHistory = new EventsHistory(p, events);
        this.p = p;
        this.skin = skin;
        this.skinParam = skinParam;
        this.englober = englober;
        this.posB = position;
        if (p.getType() == ParticipantType.PARTICIPANT) {
            this.headType = ComponentType.PARTICIPANT_HEAD;
            this.tailType = ComponentType.PARTICIPANT_TAIL;
        } else if (p.getType() == ParticipantType.ACTOR) {
            this.headType = ComponentType.ACTOR_HEAD;
            this.tailType = ComponentType.ACTOR_TAIL;
        } else if (p.getType() == ParticipantType.BOUNDARY) {
            this.headType = ComponentType.BOUNDARY_HEAD;
            this.tailType = ComponentType.BOUNDARY_TAIL;
        } else if (p.getType() == ParticipantType.CONTROL) {
            this.headType = ComponentType.CONTROL_HEAD;
            this.tailType = ComponentType.CONTROL_TAIL;
        } else if (p.getType() == ParticipantType.ENTITY) {
            this.headType = ComponentType.ENTITY_HEAD;
            this.tailType = ComponentType.ENTITY_TAIL;
        } else if (p.getType() == ParticipantType.QUEUE) {
            this.headType = ComponentType.QUEUE_HEAD;
            this.tailType = ComponentType.QUEUE_TAIL;
        } else if (p.getType() == ParticipantType.DATABASE) {
            this.headType = ComponentType.DATABASE_HEAD;
            this.tailType = ComponentType.DATABASE_TAIL;
        } else if (p.getType() == ParticipantType.COLLECTIONS) {
            this.headType = ComponentType.COLLECTIONS_HEAD;
            this.tailType = ComponentType.COLLECTIONS_TAIL;
        } else {
            throw new IllegalArgumentException();
        }
        this.useContinueLineBecauseOfDelay = this.useContinueLineBecauseOfDelay(events);
        this.mutingLine = new MutingLine(skin, skinParam, events);
        this.liveBoxes = new LiveBoxes(this.eventsHistory, skin, skinParam, p);
    }

    private boolean useContinueLineBecauseOfDelay(List<Event> events) {
        String strategy = this.skinParam.getValue("lifelineStrategy");
        if ("nosolid".equalsIgnoreCase(strategy)) {
            return false;
        }
        for (Event ev : events) {
            if (!(ev instanceof Delay)) continue;
            return true;
        }
        return false;
    }

    public void drawLineAndLiveBoxes(UGraphic ug, double height, Context2D context) {
        this.mutingLine.drawLine(ug, context, this.createY, height);
        this.liveBoxes.drawBoxes(ug, context, this.createY, height);
    }

    public void drawHead(UGraphic ug, Context2D context, VerticalAlignment verticalAlignment, HorizontalAlignment horizontalAlignment) {
        if (this.create && verticalAlignment == VerticalAlignment.BOTTOM) {
            return;
        }
        Component comp = this.rose.createComponent(this.headType, null, this.p.getSkinParamBackcolored(this.skinParam), this.p.getDisplay(this.skinParam.forceSequenceParticipantUnderlined()));
        Dimension2D dim = comp.getPreferredDimension(ug.getStringBounder());
        if (horizontalAlignment == HorizontalAlignment.RIGHT) {
            ug = ug.apply(new UTranslate(-dim.getWidth(), 0.0));
        }
        if (verticalAlignment == VerticalAlignment.CENTER) {
            ug = ug.apply(new UTranslate(0.0, -dim.getHeight() / 2.0));
        }
        Area area = new Area(dim);
        Url url = this.getParticipant().getUrl();
        if (url != null) {
            ug.startUrl(url);
        }
        comp.drawU(ug, area, context);
        if (url != null) {
            ug.closeAction();
        }
    }

    public Dimension2D getHeadPreferredDimension(StringBounder stringBounder) {
        Component comp = this.rose.createComponent(this.headType, null, this.skinParam, this.p.getDisplay(this.skinParam.forceSequenceParticipantUnderlined()));
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        return dim;
    }

    private double getPreferredWidth(StringBounder stringBounder) {
        return this.getHeadPreferredDimension(stringBounder).getWidth();
    }

    public Real getPosC(StringBounder stringBounder) {
        if (this.posC == null) {
            this.posC = this.posB.addFixed(this.getPreferredWidth(stringBounder) / 2.0);
        }
        return this.posC;
    }

    public Real getPosC2(StringBounder stringBounder) {
        double delta = this.liveBoxes.getMaxPosition(stringBounder);
        return this.getPosC(stringBounder).addFixed(delta);
    }

    public Real getPosD(StringBounder stringBounder) {
        if (this.posD == null) {
            this.posD = this.posB.addFixed(this.getPreferredWidth(stringBounder));
        }
        return this.posD;
    }

    public Real getPosB() {
        return this.posB;
    }

    public Participant getParticipant() {
        return this.p;
    }

    public void goCreate(double y) {
        this.createY = y;
        this.create = true;
    }

    public void goCreate() {
        this.create = true;
    }

    public void delayOn(double y, double height) {
        this.mutingLine.delayOn(y, height);
        this.liveBoxes.delayOn(y, height);
    }

    public ParticipantEnglober getEnglober() {
        return this.englober;
    }
}

