/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.AnnotatedWorker;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.EntityImageLegend;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.DisplaySection;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.png.PngTitler;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealOrigin;
import net.sourceforge.plantuml.real.RealUtils;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.sequencediagram.graphic.FileMaker;
import net.sourceforge.plantuml.sequencediagram.teoz.ComponentAdapter;
import net.sourceforge.plantuml.sequencediagram.teoz.Englobers;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpaces;
import net.sourceforge.plantuml.sequencediagram.teoz.PlayingSpace;
import net.sourceforge.plantuml.sequencediagram.teoz.PlayingSpaceWithParticipants;
import net.sourceforge.plantuml.sequencediagram.teoz.TeozLayer;
import net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import net.sourceforge.plantuml.skin.SimpleContext2D;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.utils.MathUtils;

public class SequenceDiagramFileMakerTeoz
implements FileMaker {
    private final SequenceDiagram diagram;
    private final FileFormatOption fileFormatOption;
    private final Rose skin;
    private final AnnotatedWorker annotatedWorker;
    private Englobers englobers;
    private final StringBounder stringBounder;
    private final TextBlock footer;
    private final TextBlock header;
    private final PlayingSpaceWithParticipants body;
    private final TextBlock title;
    private final TextBlock legend;
    private final TextBlock caption;
    private final Dimension2D dimTotal;
    private final Real min1;
    private final LivingSpaces livingSpaces = new LivingSpaces();
    private final double heightEnglober1;
    private final double heightEnglober2;

    public SequenceDiagramFileMakerTeoz(SequenceDiagram sequenceDiagram, Rose skin, FileFormatOption fileFormatOption) {
        this.stringBounder = fileFormatOption.getDefaultStringBounder();
        this.diagram = sequenceDiagram;
        this.fileFormatOption = fileFormatOption;
        this.skin = skin;
        this.footer = this.getFooterOrHeader(FontParam.FOOTER);
        this.header = this.getFooterOrHeader(FontParam.HEADER);
        this.annotatedWorker = new AnnotatedWorker(sequenceDiagram, sequenceDiagram.getSkinParam(), this.stringBounder);
        this.body = new PlayingSpaceWithParticipants(this.createMainTile());
        this.min1 = this.body.getMinX(this.stringBounder);
        this.title = this.getTitle();
        this.legend = this.getLegend();
        this.caption = this.annotatedWorker.getCaption();
        this.heightEnglober1 = this.englobers.getOffsetForEnglobers(this.stringBounder);
        this.heightEnglober2 = this.heightEnglober1 == 0.0 ? 0.0 : 10.0;
        double totalWidth = MathUtils.max(this.body.calculateDimension(this.stringBounder).getWidth(), this.title.calculateDimension(this.stringBounder).getWidth(), this.footer.calculateDimension(this.stringBounder).getWidth(), this.header.calculateDimension(this.stringBounder).getWidth(), this.legend.calculateDimension(this.stringBounder).getWidth());
        double totalHeight = this.body.calculateDimension(this.stringBounder).getHeight() + this.heightEnglober1 + this.heightEnglober2 + this.title.calculateDimension(this.stringBounder).getHeight() + this.header.calculateDimension(this.stringBounder).getHeight() + this.legend.calculateDimension(this.stringBounder).getHeight() + this.footer.calculateDimension(this.stringBounder).getHeight();
        this.dimTotal = new Dimension2DDouble(totalWidth, totalHeight);
    }

    private double oneOf(double a, double b) {
        if (a == 1.0) {
            return b;
        }
        return a;
    }

    @Override
    public ImageData createOne(OutputStream os, final int index, boolean isWithMetadata) throws IOException {
        double dpiFactor = this.diagram.getDpiFactor(this.fileFormatOption, this.dimTotal);
        double scale = 1.0;
        String metadata = this.fileFormatOption.isWithMetadata() ? this.diagram.getMetadata() : null;
        ImageBuilder imageBuilder = new ImageBuilder(this.diagram.getSkinParam(), this.oneOf(1.0, dpiFactor), metadata, null, 3.0, 10.0, this.diagram.getAnimation());
        imageBuilder.setUDrawable(new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                SequenceDiagramFileMakerTeoz.this.drawInternal(ug, index);
            }
        });
        return imageBuilder.writeImageTOBEMOVED(this.fileFormatOption, this.diagram.seed(), os);
    }

    private UGraphic goDownAndCenterForEnglobers(UGraphic ug) {
        ug = this.goDown(ug, this.title);
        ug = this.goDown(ug, this.header);
        if (this.diagram.getLegend().getVerticalAlignment() == VerticalAlignment.TOP) {
            ug = this.goDown(ug, this.legend);
        }
        double dx = (this.dimTotal.getWidth() - this.body.calculateDimension(this.stringBounder).getWidth()) / 2.0;
        return ug.apply(new UTranslate(dx, 0.0));
    }

    private UGraphic goDown(UGraphic ug, TextBlock size) {
        return ug.apply(new UTranslate(0.0, size.calculateDimension(this.stringBounder).getHeight()));
    }

    public void printAligned(UGraphic ug, HorizontalAlignment align, TextBlock layer) {
        double dx = 0.0;
        if (align == HorizontalAlignment.RIGHT) {
            dx = this.dimTotal.getWidth() - layer.calculateDimension(this.stringBounder).getWidth();
        } else if (align == HorizontalAlignment.CENTER) {
            dx = (this.dimTotal.getWidth() - layer.calculateDimension(this.stringBounder).getWidth()) / 2.0;
        }
        layer.drawU(ug.apply(new UTranslate(dx, 0.0)));
    }

    private PlayingSpace createMainTile() {
        RealOrigin origin = RealUtils.createOrigin();
        Real currentPos = origin.addAtLeast(0.0);
        for (Participant p : this.diagram.participants()) {
            LivingSpace livingSpace = new LivingSpace(p, this.diagram.getEnglober(p), this.skin, this.getSkinParam(), currentPos, this.diagram.events());
            this.livingSpaces.put(p, livingSpace);
            currentPos = livingSpace.getPosD(this.stringBounder).addAtLeast(0.0);
        }
        TileArguments tileArguments = new TileArguments(this.stringBounder, this.livingSpaces, this.skin, this.diagram.getSkinParam(), origin);
        this.englobers = new Englobers(tileArguments);
        PlayingSpace mainTile = new PlayingSpace(this.diagram, this.englobers, tileArguments);
        this.livingSpaces.addConstraints(this.stringBounder);
        mainTile.addConstraints(this.stringBounder);
        this.englobers.addConstraints(this.stringBounder);
        origin.compileNow();
        tileArguments.setBordered(mainTile);
        return mainTile;
    }

    public ISkinParam getSkinParam() {
        return this.diagram.getSkinParam();
    }

    private TextBlock getTitle() {
        if (this.diagram.getTitle().isNull()) {
            return new ComponentAdapter(null);
        }
        TextBlock compTitle = TextBlockUtils.title(new FontConfiguration(this.getSkinParam(), FontParam.SEQUENCE_TITLE, null), this.diagram.getTitle().getDisplay(), this.getSkinParam());
        return TextBlockUtils.withMargin(compTitle, 7.0, 7.0);
    }

    private TextBlock getLegend() {
        Display legend = this.diagram.getLegend().getDisplay();
        if (Display.isNull(legend)) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        return EntityImageLegend.create(legend, this.diagram.getSkinParam());
    }

    public TextBlock getFooterOrHeader(FontParam param) {
        if (this.diagram.getFooterOrHeaderTeoz(param).isNull()) {
            return new TeozLayer(null, this.stringBounder, param);
        }
        DisplaySection display = this.diagram.getFooterOrHeaderTeoz(param);
        HtmlColor hyperlinkColor = this.getSkinParam().getHyperlinkColor();
        HtmlColor titleColor = this.getSkinParam().getFontHtmlColor(null, param);
        String fontFamily = this.getSkinParam().getFont(null, false, param).getFamily(null);
        int fontSize = this.getSkinParam().getFont(null, false, param).getSize();
        PngTitler pngTitler = new PngTitler(titleColor, display, fontSize, fontFamily, hyperlinkColor, this.getSkinParam().useUnderlineForHyperlink());
        return new TeozLayer(pngTitler, this.stringBounder, param);
    }

    @Override
    public int getNbPages() {
        return this.body.getNbPages();
    }

    private void drawInternal(UGraphic ug, int index) {
        this.body.setIndex(index);
        UTranslate min1translate = new UTranslate(-this.min1.getCurrentValue(), 0.0);
        ug = ug.apply(min1translate);
        this.englobers.drawEnglobers(this.goDownAndCenterForEnglobers(ug), this.body.calculateDimension(this.stringBounder).getHeight() + this.heightEnglober1 + this.heightEnglober2 / 2.0, new SimpleContext2D(true));
        this.printAligned(ug, this.diagram.getFooterOrHeaderTeoz(FontParam.HEADER).getHorizontalAlignment(), this.header);
        ug = this.goDown(ug, this.header);
        this.printAligned(ug, HorizontalAlignment.CENTER, this.title);
        ug = this.goDown(ug, this.title);
        if (this.diagram.getLegend().getVerticalAlignment() == VerticalAlignment.TOP) {
            this.printAligned(ug, this.diagram.getLegend().getHorizontalAlignment(), this.legend);
            ug = this.goDown(ug, this.legend);
        }
        ug = ug.apply(new UTranslate(0.0, this.heightEnglober1));
        this.printAligned(ug, HorizontalAlignment.CENTER, this.body);
        ug = this.goDown(ug, this.body);
        ug = ug.apply(new UTranslate(0.0, this.heightEnglober2));
        this.printAligned(ug, HorizontalAlignment.CENTER, this.caption);
        if (this.diagram.getLegend().getVerticalAlignment() == VerticalAlignment.BOTTOM) {
            this.printAligned(ug, this.diagram.getLegend().getHorizontalAlignment(), this.legend);
            ug = this.goDown(ug, this.legend);
        }
        this.printAligned(ug, this.diagram.getFooterOrHeaderTeoz(FontParam.FOOTER).getHorizontalAlignment(), this.footer);
    }
}

