/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.suggest;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.suggest.SuggestEngineStatus;

public class SuggestEngineResult {
    private final SuggestEngineStatus status;
    private final String suggestedLine;
    public static final SuggestEngineResult CANNOT_CORRECT = new SuggestEngineResult(SuggestEngineStatus.CANNOT_CORRECT);
    public static final SuggestEngineResult SYNTAX_OK = new SuggestEngineResult(SuggestEngineStatus.SYNTAX_OK);

    private SuggestEngineResult(SuggestEngineStatus status) {
        if (status == SuggestEngineStatus.ONE_SUGGESTION) {
            throw new IllegalArgumentException();
        }
        this.status = status;
        this.suggestedLine = null;
    }

    public String toString() {
        return (Object)((Object)this.status) + " " + this.suggestedLine;
    }

    public int hashCode() {
        return this.status.hashCode() + (this.suggestedLine == null ? 0 : this.suggestedLine.hashCode());
    }

    public boolean equals(Object obj) {
        SuggestEngineResult this2 = (SuggestEngineResult)obj;
        return this.status.equals((Object)this2.status) && SuggestEngineResult.sameString(this.suggestedLine, this2.suggestedLine);
    }

    private static boolean sameString(String a, String b) {
        return a == null && b == null || a != null && a.equals(b);
    }

    public SuggestEngineResult(String suggestedLine) {
        if (StringUtils.trin(suggestedLine).length() == 0) {
            throw new IllegalArgumentException();
        }
        this.status = SuggestEngineStatus.ONE_SUGGESTION;
        this.suggestedLine = suggestedLine;
    }

    public final SuggestEngineStatus getStatus() {
        return this.status;
    }

    public final String getSuggestedLine() {
        return this.suggestedLine;
    }
}

