/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Hideable;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.EntityPosition;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.posimo.Positionable;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ClusterPosition;
import net.sourceforge.plantuml.svek.ColorSequence;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.IShapePseudo;
import net.sourceforge.plantuml.svek.Margins;
import net.sourceforge.plantuml.svek.PortGeometry;
import net.sourceforge.plantuml.svek.Ports;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.SvekUtils;
import net.sourceforge.plantuml.svek.WithPorts;
import net.sourceforge.plantuml.svek.image.EntityImageDescription;
import net.sourceforge.plantuml.svek.image.EntityImageLollipopInterface;
import net.sourceforge.plantuml.svek.image.EntityImageStateBorder;
import net.sourceforge.plantuml.ugraphic.Shadowable;
import net.sourceforge.plantuml.ugraphic.UPolygon;

public class Shape
implements Positionable,
IShapePseudo,
Hideable {
    private final ShapeType type;
    private final double width;
    private final double height;
    private final String uid;
    private final int color;
    private double minX;
    private double minY;
    private final Margins shield;
    private final EntityPosition entityPosition;
    private final IEntityImage image;
    private Cluster cluster;
    private final boolean top;
    private Shadowable octagon;

    public EntityPosition getEntityPosition() {
        return this.entityPosition;
    }

    public final Cluster getCluster() {
        return this.cluster;
    }

    public final void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public String toString() {
        return super.toString() + " " + this.image + " " + (Object)((Object)this.type);
    }

    public Shape(IEntityImage image, ShapeType type, double width, double height, ColorSequence colorSequence, boolean top, Margins shield, EntityPosition entityPosition) {
        this.entityPosition = entityPosition;
        this.image = image;
        this.top = top;
        this.type = type;
        this.width = width;
        this.height = height;
        this.color = colorSequence.getValue();
        this.uid = String.format("sh%04d", this.color);
        this.shield = shield;
        if (!shield.isZero() && type != ShapeType.RECTANGLE && type != ShapeType.RECTANGLE_HTML_FOR_PORTS && type != ShapeType.RECTANGLE_WITH_CIRCLE_INSIDE) {
            throw new IllegalArgumentException();
        }
    }

    public final ShapeType getType() {
        return this.type;
    }

    public final double getWidth() {
        return this.width;
    }

    public final double getHeight() {
        return this.height;
    }

    @Override
    public void appendShape(StringBuilder sb, StringBounder stringBounder) {
        if (this.type == ShapeType.RECTANGLE_HTML_FOR_PORTS) {
            this.appendLabelHtmlSpecialForLink(sb, stringBounder);
            return;
        }
        if (this.type == ShapeType.RECTANGLE_WITH_CIRCLE_INSIDE) {
            this.appendHtml(sb);
            return;
        }
        if (this.type == ShapeType.RECTANGLE && !this.shield.isZero()) {
            this.appendHtml(sb);
            return;
        }
        sb.append(this.uid);
        sb.append(" [");
        this.appendShapeInternal(sb);
        sb.append(",");
        sb.append("label=\"\"");
        sb.append(",");
        sb.append("width=" + SvekUtils.pixelToInches(this.getWidth()));
        sb.append(",");
        sb.append("height=" + SvekUtils.pixelToInches(this.getHeight()));
        sb.append(",");
        sb.append("color=\"" + StringUtils.getAsHtml(this.color) + "\"");
        sb.append("];");
        SvekUtils.println(sb);
    }

    private void appendHtml(StringBuilder sb) {
        sb.append(this.uid);
        sb.append(" [");
        sb.append("shape=plaintext,");
        sb.append("label=<");
        this.appendLabelHtml(sb);
        sb.append(">");
        sb.append("];");
        SvekUtils.println(sb);
    }

    private void appendLabelHtml(StringBuilder sb) {
        sb.append("<TABLE BORDER=\"0\" CELLBORDER=\"0\" CELLSPACING=\"0\" CELLPADDING=\"0\">");
        sb.append("<TR>");
        this.appendTd(sb);
        this.appendTd(sb, 1.0, this.shield.getY1());
        this.appendTd(sb);
        sb.append("</TR>");
        sb.append("<TR>");
        this.appendTd(sb, this.shield.getX1(), 1.0);
        sb.append("<TD BGCOLOR=\"" + StringUtils.getAsHtml(this.color) + "\"");
        sb.append(" FIXEDSIZE=\"TRUE\" WIDTH=\"" + this.getWidth() + "\" HEIGHT=\"" + this.getHeight() + "\"");
        sb.append(" PORT=\"h\">");
        sb.append("</TD>");
        this.appendTd(sb, this.shield.getX2(), 1.0);
        sb.append("</TR>");
        sb.append("<TR>");
        this.appendTd(sb);
        this.appendTd(sb, 1.0, this.shield.getY2());
        this.appendTd(sb);
        sb.append("</TR>");
        sb.append("</TABLE>");
    }

    private void appendLabelHtmlSpecialForLink(StringBuilder sb, StringBounder stringBounder) {
        Ports ports = ((WithPorts)((Object)this.image)).getPorts(stringBounder);
        sb.append(this.uid);
        sb.append(" [");
        sb.append("shape=plaintext,");
        sb.append("label=<");
        sb.append("<TABLE BGCOLOR=\"" + StringUtils.getAsHtml(this.color) + "\" BORDER=\"0\" CELLBORDER=\"0\" CELLSPACING=\"0\" CELLPADDING=\"0\">");
        double position = 0.0;
        for (Map.Entry<String, PortGeometry> ent : ports.getAll().entrySet()) {
            String portName = ent.getKey();
            PortGeometry geom = ent.getValue();
            double missing = geom.getPosition() - position;
            this.appendTr(sb, null, missing);
            this.appendTr(sb, portName, geom.getHeight());
            position = geom.getLastY();
        }
        this.appendTr(sb, null, this.getHeight() - position);
        sb.append("</TABLE>");
        sb.append(">");
        sb.append("];");
        SvekUtils.println(sb);
    }

    private void appendTr(StringBuilder sb, String portName, double height) {
        if (height <= 0.0) {
            return;
        }
        sb.append("<TR>");
        sb.append("<TD ");
        sb.append(" FIXEDSIZE=\"TRUE\" WIDTH=\"" + this.getWidth() + "\" HEIGHT=\"" + height + "\"");
        if (portName != null) {
            sb.append(" PORT=\"" + portName + "\"");
        }
        sb.append(">");
        sb.append("</TD>");
        sb.append("</TR>");
    }

    private void appendTd(StringBuilder sb, double w, double h) {
        sb.append("<TD");
        sb.append(" FIXEDSIZE=\"TRUE\" WIDTH=\"" + w + "\" HEIGHT=\"" + h + "\"");
        sb.append(">");
        sb.append("</TD>");
    }

    private void appendTd(StringBuilder sb) {
        sb.append("<TD>");
        sb.append("</TD>");
    }

    private void appendShapeInternal(StringBuilder sb) {
        if (this.type == ShapeType.RECTANGLE && !this.shield.isZero()) {
            throw new UnsupportedOperationException();
        }
        if (this.type == ShapeType.RECTANGLE || this.type == ShapeType.RECTANGLE_WITH_CIRCLE_INSIDE || this.type == ShapeType.FOLDER) {
            sb.append("shape=rect");
        } else {
            if (this.type == ShapeType.RECTANGLE_HTML_FOR_PORTS) {
                throw new UnsupportedOperationException();
            }
            if (this.type == ShapeType.OCTAGON) {
                sb.append("shape=octagon");
            } else if (this.type == ShapeType.DIAMOND) {
                sb.append("shape=diamond");
            } else if (this.type == ShapeType.CIRCLE) {
                sb.append("shape=circle");
            } else if (this.type == ShapeType.CIRCLE_IN_RECT) {
                sb.append("shape=circle");
            } else if (this.type == ShapeType.OVAL) {
                sb.append("shape=ellipse");
            } else if (this.type == ShapeType.ROUND_RECTANGLE) {
                sb.append("shape=rect,style=rounded");
            } else {
                throw new IllegalStateException(this.type.toString());
            }
        }
    }

    @Override
    public final String getUid() {
        if (this.uid == null) {
            throw new IllegalStateException();
        }
        return this.uid;
    }

    public final double getMinX() {
        return this.minX;
    }

    public final double getMinY() {
        return this.minY;
    }

    public IEntityImage getImage() {
        return this.image;
    }

    public final boolean isTop() {
        return this.top;
    }

    @Override
    public Point2D getPosition() {
        return new Point2D.Double(this.minX, this.minY);
    }

    @Override
    public Dimension2D getSize() {
        return new Dimension2DDouble(this.width, this.height);
    }

    public ClusterPosition getClusterPosition() {
        return new ClusterPosition(this.minX, this.minY, this.minX + this.width, this.minY + this.height);
    }

    public boolean isShielded() {
        return !this.shield.isZero();
    }

    @Override
    public void moveSvek(double deltaX, double deltaY) {
        this.minX += deltaX;
        this.minY += deltaY;
    }

    public double getMaxWidthFromLabelForEntryExit(StringBounder stringBounder) {
        EntityImageStateBorder im = (EntityImageStateBorder)this.image;
        return im.getMaxWidthFromLabelForEntryExit(stringBounder);
    }

    @Override
    public boolean isHidden() {
        return this.image.isHidden();
    }

    public void setOctagon(double minX, double minY, List<Point2D.Double> points) {
        this.octagon = new UPolygon(points).translate(-minX, -minY);
    }

    public Shadowable getOctagon() {
        return this.octagon;
    }

    public Point2D getPoint2D(double x, double y) {
        return new Point2D.Double(this.minX + x, this.minY + y);
    }

    public Point2D projection(Point2D pt, StringBounder stringBounder) {
        if (this.getType() != ShapeType.FOLDER) {
            return pt;
        }
        ClusterPosition clusterPosition = new ClusterPosition(this.minX, this.minY, this.minX + this.width, this.minY + this.height);
        if (clusterPosition.isPointJustUpper(pt)) {
            Dimension2D dimName = ((EntityImageDescription)this.image).getNameDimension(stringBounder);
            if (pt.getX() < this.minX + dimName.getWidth()) {
                return pt;
            }
            return new Point2D.Double(pt.getX(), pt.getY() + dimName.getHeight() + 4.0);
        }
        return pt;
    }

    public double getOverscanX(StringBounder stringBounder) {
        return this.image.getOverscanX(stringBounder);
    }

    public void addImpact(double angle) {
        ((EntityImageLollipopInterface)this.image).addImpact(angle);
    }
}

