/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class EntityImageBranch
extends AbstractEntityImage {
    private static final int SIZE = 12;

    public EntityImageBranch(ILeaf entity, ISkinParam skinParam) {
        super(entity, skinParam);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(24.0, 24.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        UPolygon diams = new UPolygon();
        if (this.getSkinParam().shadowing(this.getEntity().getStereotype())) {
            diams.setDeltaShadow(5.0);
        }
        diams.addPoint(12.0, 0.0);
        diams.addPoint(24.0, 12.0);
        diams.addPoint(12.0, 24.0);
        diams.addPoint(0.0, 12.0);
        diams.addPoint(12.0, 0.0);
        HtmlColor border = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.activityDiamondBorder, ColorParam.activityBorder);
        HtmlColor back = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.activityDiamondBackground, ColorParam.activityBackground);
        ug.apply(new UChangeColor(border)).apply(new UChangeBackColor(back)).apply(new UStroke(1.5)).draw(diams);
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.DIAMOND;
    }
}

