/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim;

import java.util.ArrayList;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TFunctionArgument;
import net.sourceforge.plantuml.tim.TFunctionImpl;
import net.sourceforge.plantuml.tim.TLineType;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.expression.TValue;
import net.sourceforge.plantuml.tim.expression.Token;
import net.sourceforge.plantuml.tim.expression.TokenStack;
import net.sourceforge.plantuml.tim.expression.TokenType;

public abstract class Eater {
    private int i = 0;
    private final String s;

    public Eater(String s) {
        this.s = s;
    }

    public abstract void execute(TContext var1, TMemory var2) throws EaterException;

    public int getCurrentPosition() {
        return this.i;
    }

    protected final String eatAllToEnd() throws EaterException {
        String result = this.s.substring(this.i);
        this.i = this.s.length();
        return result;
    }

    protected final TValue eatExpression(TContext context, TMemory memory) throws EaterException {
        TokenStack tokenStack = new TokenStack();
        this.addIntoTokenStack(tokenStack, false);
        return tokenStack.getResult(context, memory);
    }

    protected final TValue eatExpressionStopAtColon(TContext context, TMemory memory) throws EaterException {
        TokenStack tokenStack = new TokenStack();
        this.addIntoTokenStack(tokenStack, true);
        return tokenStack.getResult(context, memory);
    }

    protected final void addIntoTokenStack(TokenStack tokenStack, boolean stopAtColon) throws EaterException {
        Token token;
        while ((token = TokenType.eatOneToken(this, stopAtColon)) != null) {
            tokenStack.add(token);
        }
        return;
    }

    public final String eatAndGetQuotedString() throws EaterException {
        char separator = this.peekChar();
        if (!TLineType.isQuote(separator)) {
            throw new EaterException("quote10");
        }
        this.checkAndEatChar(separator);
        StringBuilder value = new StringBuilder();
        this.addUpTo(separator, value);
        this.checkAndEatChar(separator);
        return value.toString();
    }

    protected final String eatAndGetOptionalQuotedString() throws EaterException {
        char quote = this.peekChar();
        if (TLineType.isQuote(quote)) {
            return this.eatAndGetQuotedString();
        }
        StringBuilder value = new StringBuilder();
        this.addUpTo(',', ')', value);
        return value.toString();
    }

    public final String eatAndGetNumber() throws EaterException {
        StringBuilder result = new StringBuilder();
        char ch;
        while ((ch = this.peekChar()) != '\u0000' && TLineType.isLatinDigit(ch)) {
            result.append(this.eatOneChar());
        }
        return result.toString();
    }

    public final String eatAndGetSpaces() throws EaterException {
        StringBuilder result = new StringBuilder();
        char ch;
        while ((ch = this.peekChar()) != '\u0000' && TLineType.isSpaceChar(ch)) {
            result.append(this.eatOneChar());
        }
        return result.toString();
    }

    protected final String eatAntGetVarname() throws EaterException {
        StringBuilder varname = new StringBuilder("" + this.eatOneChar());
        if (!TLineType.isLetterOrUnderscoreOrDollar(varname.charAt(0))) {
            throw new EaterException("a002");
        }
        this.addUpToLastLetterOrUnderscoreOrDigit(varname);
        return varname.toString();
    }

    protected final String eatAntGetFunctionName() throws EaterException {
        StringBuilder varname = new StringBuilder("" + this.eatOneChar());
        if (!TLineType.isLetterOrUnderscoreOrDollar(varname.charAt(0))) {
            throw new EaterException("a003");
        }
        this.addUpToLastLetterOrUnderscoreOrDigit(varname);
        return varname.toString();
    }

    public final void skipSpaces() {
        while (this.i < this.s.length() && Character.isSpaceChar(this.s.charAt(this.i))) {
            ++this.i;
        }
    }

    protected final void skipUntilChar(char ch) {
        while (this.i < this.s.length() && this.s.charAt(this.i) != ch) {
            ++this.i;
        }
    }

    public final char peekChar() {
        if (this.i >= this.s.length()) {
            return '\u0000';
        }
        return this.s.charAt(this.i);
    }

    public final char peekCharN2() {
        if (this.i + 1 >= this.s.length()) {
            return '\u0000';
        }
        return this.s.charAt(this.i + 1);
    }

    protected final boolean hasNextChar() {
        return this.i < this.s.length();
    }

    public final char eatOneChar() {
        char ch = this.s.charAt(this.i);
        ++this.i;
        return ch;
    }

    protected final void checkAndEatChar(char ch) throws EaterException {
        if (this.i >= this.s.length() || this.s.charAt(this.i) != ch) {
            throw new EaterException("a001");
        }
        ++this.i;
    }

    protected final void optionallyEatChar(char ch) throws EaterException {
        if (this.i >= this.s.length() || this.s.charAt(this.i) != ch) {
            return;
        }
        assert (this.s.charAt(this.i) == ch);
        ++this.i;
    }

    protected final void checkAndEatChar(String s) throws EaterException {
        for (int j = 0; j < s.length(); ++j) {
            this.checkAndEatChar(s.charAt(j));
        }
    }

    protected final void addUpToLastLetterOrUnderscoreOrDigit(StringBuilder sb) {
        while (this.i < this.s.length()) {
            char ch = this.s.charAt(this.i);
            if (!TLineType.isLetterOrUnderscoreOrDigit(ch)) {
                return;
            }
            ++this.i;
            sb.append(ch);
        }
    }

    protected final void addUpTo(char separator, StringBuilder sb) {
        while (this.i < this.s.length()) {
            char ch = this.peekChar();
            if (ch == separator) {
                return;
            }
            ++this.i;
            sb.append(ch);
        }
    }

    protected final void addUpTo(char separator1, char separator2, StringBuilder sb) {
        while (this.i < this.s.length()) {
            char ch = this.peekChar();
            if (ch == separator1 || ch == separator2) {
                return;
            }
            ++this.i;
            sb.append(ch);
        }
    }

    protected final TFunctionImpl eatDeclareFunction(TContext context, TMemory memory, boolean unquoted, LineLocation location) throws EaterException {
        char ch;
        ArrayList<TFunctionArgument> args = new ArrayList<TFunctionArgument>();
        String functionName = this.eatAntGetFunctionName();
        this.skipSpaces();
        this.checkAndEatChar('(');
        while (true) {
            this.skipSpaces();
            ch = this.peekChar();
            if (TLineType.isLetterOrUnderscoreOrDollar(ch)) {
                TValue defValue;
                String varname = this.eatAntGetVarname();
                this.skipSpaces();
                if (this.peekChar() == '=') {
                    this.eatOneChar();
                    TokenStack def = TokenStack.eatUntilCloseParenthesisOrComma(this);
                    def.guessFunctions();
                    defValue = def.getResult(context, memory);
                } else {
                    defValue = null;
                }
                args.add(new TFunctionArgument(varname, defValue));
                continue;
            }
            if (ch != ',') break;
            this.checkAndEatChar(',');
        }
        if (ch != ')') {
            throw new EaterException("Error in function definition");
        }
        this.checkAndEatChar(")");
        this.skipSpaces();
        return new TFunctionImpl(functionName, args, unquoted);
    }

    protected final TFunctionImpl eatDeclareFunctionWithOptionalReturn(TContext context, TMemory memory, boolean unquoted, LineLocation location) throws EaterException {
        TFunctionImpl result = this.eatDeclareFunction(context, memory, unquoted, location);
        if (this.peekChar() == 'r') {
            this.checkAndEatChar("return");
            this.skipSpaces();
            String line = "!return " + this.eatAllToEnd();
            result.addBody(new StringLocated(line, location));
        }
        return result;
    }
}

