/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.preproc.FileWithSuffix;
import net.sourceforge.plantuml.preproc.ImportedFiles;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc2.PreprocessorInclude;
import net.sourceforge.plantuml.tim.ConditionalContext;
import net.sourceforge.plantuml.tim.EaterAffectation;
import net.sourceforge.plantuml.tim.EaterAffectationDefine;
import net.sourceforge.plantuml.tim.EaterAssert;
import net.sourceforge.plantuml.tim.EaterDeclareFunction;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.EaterFunctionCall;
import net.sourceforge.plantuml.tim.EaterIf;
import net.sourceforge.plantuml.tim.EaterIfdef;
import net.sourceforge.plantuml.tim.EaterIfndef;
import net.sourceforge.plantuml.tim.EaterImport;
import net.sourceforge.plantuml.tim.EaterInclude;
import net.sourceforge.plantuml.tim.EaterLegacyDefine;
import net.sourceforge.plantuml.tim.EaterLegacyDefineLong;
import net.sourceforge.plantuml.tim.TFunction;
import net.sourceforge.plantuml.tim.TFunctionImpl;
import net.sourceforge.plantuml.tim.TFunctionSignature;
import net.sourceforge.plantuml.tim.TFunctionType;
import net.sourceforge.plantuml.tim.TLineType;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.TVariable;
import net.sourceforge.plantuml.tim.Trie;
import net.sourceforge.plantuml.tim.expression.Knowledge;
import net.sourceforge.plantuml.tim.expression.TValue;
import net.sourceforge.plantuml.tim.stdlib.DateFunction;
import net.sourceforge.plantuml.tim.stdlib.Dirpath;
import net.sourceforge.plantuml.tim.stdlib.FileExists;
import net.sourceforge.plantuml.tim.stdlib.Filename;
import net.sourceforge.plantuml.tim.stdlib.Getenv;
import net.sourceforge.plantuml.tim.stdlib.Strlen;
import net.sourceforge.plantuml.tim.stdlib.Strpos;
import net.sourceforge.plantuml.tim.stdlib.Substr;

public class TContext {
    private final ArrayList<StringLocated> result = new ArrayList();
    private final Map<TFunctionSignature, TFunction> functions2 = new HashMap<TFunctionSignature, TFunction>();
    private final Trie functions3 = new Trie();
    private final ImportedFiles importedFiles;
    private TFunctionImpl pendingFunction;
    private String pendingAdd = null;

    private void addStandardFunctions(Defines defines) {
        this.addFunction(new Strlen());
        this.addFunction(new Substr());
        this.addFunction(new FileExists());
        this.addFunction(new Getenv());
        this.addFunction(new Dirpath(defines));
        this.addFunction(new Filename(defines));
        this.addFunction(new DateFunction());
        this.addFunction(new Strpos());
    }

    public TContext(ImportedFiles importedFiles, Defines defines) {
        this.importedFiles = importedFiles;
        this.addStandardFunctions(defines);
    }

    public Knowledge asKnowledge(final TMemory memory) {
        return new Knowledge(){

            @Override
            public TVariable getVariable(String name) {
                return memory.getVariable(name);
            }

            @Override
            public TFunction getFunction(TFunctionSignature name) {
                return TContext.this.getFunctionSmart(name);
            }
        };
    }

    private TFunction getFunctionSmart(TFunctionSignature searched) {
        TFunction func = this.functions2.get(searched);
        if (func != null) {
            return func;
        }
        for (TFunction candidate : this.functions2.values()) {
            if (!candidate.getSignature().sameNameAs(searched) || !candidate.canCover(searched.getNbArg())) continue;
            return candidate;
        }
        return null;
    }

    public CommandExecutionResult executeOneLine(TMemory memory, TLineType type, StringLocated s, TFunctionType fromType) {
        if (this.getPendingFunction() != null) {
            if (type == TLineType.END_FUNCTION) {
                this.executeEndfunction();
            } else {
                this.getPendingFunction().addBody(s);
            }
            return CommandExecutionResult.ok();
        }
        assert (type == TLineType.getFromLine(s.getString()));
        try {
            if (type == TLineType.ASSERT) {
                return this.executeAssert(memory, s.getStringTrimmed());
            }
            if (type == TLineType.IF) {
                return this.executeIf(memory, s.getStringTrimmed());
            }
            if (type == TLineType.IFDEF) {
                return this.executeIfdef(memory, s.getStringTrimmed());
            }
            if (type == TLineType.IFNDEF) {
                return this.executeIfndef(memory, s.getStringTrimmed());
            }
            if (type == TLineType.ELSE) {
                return this.executeElse(memory, s.getStringTrimmed());
            }
            if (type == TLineType.ENDIF) {
                return this.executeEndif(memory, s.getStringTrimmed());
            }
            ConditionalContext conditionalContext = memory.peekConditionalContext();
            if (conditionalContext != null && !conditionalContext.conditionIsOkHere()) {
                return CommandExecutionResult.ok();
            }
            if (fromType != TFunctionType.RETURN && type == TLineType.PLAIN) {
                return this.addPlain(memory, s);
            }
            if (fromType == TFunctionType.RETURN && type == TLineType.RETURN) {
                return CommandExecutionResult.ok();
            }
            if (type == TLineType.LEGACY_DEFINE) {
                return this.executeLegacyDefine(memory, s);
            }
            if (type == TLineType.LEGACY_DEFINELONG) {
                return this.executeLegacyDefineLong(memory, s);
            }
            if (type == TLineType.AFFECTATION_DEFINE) {
                return this.executeAffectationDefine(memory, s.getStringTrimmed());
            }
            if (type == TLineType.AFFECTATION) {
                return this.executeAffectation(memory, s.getStringTrimmed());
            }
            if (fromType == null && type == TLineType.DECLARE_FUNCTION) {
                return this.executeDeclareFunction(memory, s);
            }
            if (fromType == null && type == TLineType.END_FUNCTION) {
                return CommandExecutionResult.error("error endfunc");
            }
            if (type == TLineType.INCLUDE) {
                return this.executeInclude(memory, s);
            }
            if (type == TLineType.IMPORT) {
                return this.executeImport(memory, s);
            }
            throw new UnsupportedOperationException("type=" + (Object)((Object)type) + " fromType=" + (Object)((Object)fromType));
        }
        catch (EaterException e) {
            e.printStackTrace();
            return CommandExecutionResult.error(e.getMessage());
        }
    }

    private CommandExecutionResult addPlain(TMemory memory, StringLocated s) throws EaterException {
        StringLocated tmp = this.applyFunctionsAndVariables(memory, s);
        if (tmp != null) {
            if (this.pendingAdd != null) {
                tmp = new StringLocated(this.pendingAdd + tmp.getString(), tmp.getLocation());
                this.pendingAdd = null;
            }
            this.result.add(tmp);
        }
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeAffectationDefine(TMemory memory, String s) throws EaterException {
        new EaterAffectationDefine(s).execute(this, memory);
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeAffectation(TMemory memory, String s) throws EaterException {
        new EaterAffectation(s).execute(this, memory);
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeIf(TMemory memory, String s) throws EaterException {
        EaterIf condition = new EaterIf(s);
        condition.execute(this, memory);
        boolean isTrue = condition.isTrue();
        memory.addConditionalContext(ConditionalContext.fromValue(isTrue));
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeAssert(TMemory memory, String s) throws EaterException {
        EaterAssert condition = new EaterAssert(s);
        condition.execute(this, memory);
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeIfdef(TMemory memory, String s) throws EaterException {
        EaterIfdef condition = new EaterIfdef(s);
        condition.execute(this, memory);
        boolean isTrue = condition.isTrue(this, memory);
        memory.addConditionalContext(ConditionalContext.fromValue(isTrue));
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeIfndef(TMemory memory, String s) throws EaterException {
        EaterIfndef condition = new EaterIfndef(s);
        condition.execute(this, memory);
        boolean isTrue = condition.isTrue(this, memory);
        memory.addConditionalContext(ConditionalContext.fromValue(isTrue));
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeElse(TMemory memory, String s) throws EaterException {
        ConditionalContext poll = memory.peekConditionalContext();
        if (poll == null) {
            return CommandExecutionResult.error("No if related to this else");
        }
        poll.nowInElse();
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeEndif(TMemory memory, String s) throws EaterException {
        ConditionalContext poll = memory.pollConditionalContext();
        if (poll == null) {
            return CommandExecutionResult.error("No if related to this endif");
        }
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeDeclareFunction(TMemory memory, StringLocated s) throws EaterException {
        if (this.pendingFunction != null) {
            throw new EaterException("already0068");
        }
        EaterDeclareFunction declareFunction = new EaterDeclareFunction(s);
        declareFunction.execute(this, memory);
        if (this.functions2.containsKey(declareFunction.getFunction().getSignature())) {
            throw new EaterException("already0046");
        }
        if (declareFunction.getFunction().hasBody()) {
            this.addFunction(declareFunction.getFunction());
        } else {
            this.pendingFunction = declareFunction.getFunction();
        }
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeLegacyDefine(TMemory memory, StringLocated s) throws EaterException {
        if (this.pendingFunction != null) {
            throw new EaterException("already0048");
        }
        EaterLegacyDefine legacyDefine = new EaterLegacyDefine(s);
        legacyDefine.execute(this, memory);
        TFunction function = legacyDefine.getFunction();
        if (this.functions2.containsKey(function.getSignature())) {
            throw new EaterException("already0047");
        }
        this.functions2.put(function.getSignature(), function);
        this.functions3.add(function.getSignature().getFunctionName() + "(");
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeLegacyDefineLong(TMemory memory, StringLocated s) throws EaterException {
        if (this.pendingFunction != null) {
            throw new EaterException("already0068");
        }
        EaterLegacyDefineLong legacyDefineLong = new EaterLegacyDefineLong(s);
        legacyDefineLong.execute(this, memory);
        if (this.functions2.containsKey(legacyDefineLong.getFunction().getSignature())) {
            throw new EaterException("already0066");
        }
        this.pendingFunction = legacyDefineLong.getFunction();
        return CommandExecutionResult.ok();
    }

    private StringLocated applyFunctionsAndVariables(TMemory memory, StringLocated located) throws EaterException {
        if (memory.isEmpty() && this.functions2.size() == 0) {
            return located;
        }
        String s = located.getString();
        String result = this.applyFunctionsAndVariables(memory, s);
        if (result == null) {
            return null;
        }
        return new StringLocated(result, located.getLocation());
    }

    public String applyFunctionsAndVariables(TMemory memory, String s) throws EaterException {
        if (memory.isEmpty() && this.functions2.size() == 0) {
            return s;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            String presentFunction = this.getFunctionNameAt(s, i);
            if (presentFunction != null) {
                String sub = s.substring(i);
                EaterFunctionCall call = new EaterFunctionCall(sub, this.isLegacyDefine(presentFunction), this.isUnquoted(presentFunction));
                call.execute(this, memory);
                TFunction function = this.getFunctionSmart(new TFunctionSignature(presentFunction, call.getValues2().size()));
                if (function == null) {
                    throw new EaterException("Function not found " + presentFunction);
                }
                if (function.getFunctionType() == TFunctionType.VOID) {
                    function.executeVoid(this, sub, memory);
                    return null;
                }
                if (function.getFunctionType() == TFunctionType.LEGACY_DEFINELONG) {
                    this.pendingAdd = s.substring(0, i);
                    function.executeVoid(this, sub, memory);
                    return null;
                }
                assert (function.getFunctionType() == TFunctionType.RETURN || function.getFunctionType() == TFunctionType.LEGACY_DEFINE);
                TValue functionReturn = function.executeReturn(this, memory, call.getValues2());
                result.append(functionReturn.toString());
                i += call.getCurrentPosition() - 1;
                continue;
            }
            String presentVariable = TContext.getVarnameAt(memory, s, i);
            if (presentVariable != null) {
                result.append(memory.getVariable(presentVariable).getValue2().toString());
                if ((i += presentVariable.length() - 1) + 2 >= s.length() || s.charAt(i + 1) != '#' || s.charAt(i + 2) != '#') continue;
                i += 2;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private CommandExecutionResult executeImport(TMemory memory, StringLocated s) throws EaterException {
        EaterImport _import = new EaterImport(s.getStringTrimmed());
        _import.execute(this, memory);
        try {
            File file = FileSystem.getInstance().getFile(this.applyFunctionsAndVariables(memory, _import.getLocation()));
            if (file.exists() && !file.isDirectory()) {
                this.importedFiles.add(file);
                return CommandExecutionResult.ok();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return CommandExecutionResult.error("Cannot import " + e.getMessage());
        }
        return CommandExecutionResult.error("Cannot import");
    }

    private CommandExecutionResult executeInclude(TMemory memory, StringLocated s) throws EaterException {
        EaterInclude include = new EaterInclude(s.getStringTrimmed());
        include.execute(this, memory);
        String location = include.getLocation();
        int idx = location.lastIndexOf(33);
        String suf = null;
        if (idx != -1) {
            suf = location.substring(idx + 1);
            location = location.substring(0, idx);
        }
        String charset = null;
        ReadLine reader2 = null;
        try {
            FileWithSuffix f2;
            if (location.startsWith("http://") || location.startsWith("https://")) {
                URL url = new URL(location);
                reader2 = PreprocessorInclude.getReaderIncludeUrl(url, s, suf, charset);
            }
            if (location.startsWith("<") && location.endsWith(">")) {
                reader2 = PreprocessorInclude.getReaderStdlibInclude(s, location.substring(1, location.length() - 1));
            } else if (OptionFlags.ALLOW_INCLUDE && (f2 = new FileWithSuffix(this.importedFiles, location, suf)).fileOk()) {
                Reader reader = f2.getReader(charset);
                reader2 = ReadLineReader.create(reader, location, s.getLocation());
            }
            if (reader2 != null) {
                StringLocated sl;
                CommandExecutionResult exe;
                do {
                    if ((sl = reader2.readLine()) != null) continue;
                    return CommandExecutionResult.ok();
                } while ((exe = this.executeOneLine(memory, TLineType.getFromLine(sl.getString()), sl, null)).isOk());
                return exe;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return CommandExecutionResult.error("cannot include " + e);
        }
        System.err.println("location=" + location);
        return CommandExecutionResult.error("cannot include");
    }

    private Reader getReader(File file) throws FileNotFoundException, UnsupportedEncodingException {
        String charset = null;
        if (charset == null) {
            Log.info("Using default charset");
            return new InputStreamReader(new FileInputStream(file));
        }
        Log.info("Using charset " + charset);
        return new InputStreamReader((InputStream)new FileInputStream(file), charset);
    }

    public boolean isLegacyDefine(String functionName) {
        for (Map.Entry<TFunctionSignature, TFunction> ent : this.functions2.entrySet()) {
            if (!ent.getKey().getFunctionName().equals(functionName) || !ent.getValue().getFunctionType().isLegacy()) continue;
            return true;
        }
        return false;
    }

    public boolean isUnquoted(String functionName) {
        for (Map.Entry<TFunctionSignature, TFunction> ent : this.functions2.entrySet()) {
            if (!ent.getKey().getFunctionName().equals(functionName) || !ent.getValue().isUnquoted()) continue;
            return true;
        }
        return false;
    }

    public boolean doesFunctionExist(String functionName) {
        for (Map.Entry<TFunctionSignature, TFunction> ent : this.functions2.entrySet()) {
            if (!ent.getKey().getFunctionName().equals(functionName)) continue;
            return true;
        }
        return false;
    }

    private static String getVarnameAt(TMemory memory, String s, int pos) {
        String varname = memory.variablesNames3().getLonguestMatchStartingIn(s.substring(pos));
        if (varname.length() == 0) {
            return null;
        }
        if (pos + varname.length() == s.length() || !Character.isLetterOrDigit(s.charAt(pos + varname.length()))) {
            return varname;
        }
        return null;
    }

    private static String getVarnameAtOld(TMemory memory, String s, int pos) {
        for (String varname : memory.variablesNames()) {
            if (!s.substring(pos).startsWith(varname) || pos + varname.length() != s.length() && Character.isLetterOrDigit(s.charAt(pos + varname.length()))) continue;
            return varname;
        }
        return null;
    }

    private String getFunctionNameAt(String s, int pos) {
        String fname = this.functions3.getLonguestMatchStartingIn(s.substring(pos));
        if (fname.length() == 0) {
            return null;
        }
        return fname.substring(0, fname.length() - 1);
    }

    private String getFunctionNameAtOld(String s, int pos) {
        for (TFunctionSignature fname : this.functions2.keySet()) {
            if (!s.substring(pos).startsWith(fname.getFunctionName() + "(")) continue;
            return fname.getFunctionName();
        }
        return null;
    }

    public List<StringLocated> getResult() {
        return Collections.unmodifiableList(this.result);
    }

    public List<StringLocated> getResultWithError(StringLocated error) {
        this.result.add(error);
        return Collections.unmodifiableList(this.result);
    }

    public final TFunctionImpl getPendingFunction() {
        return this.pendingFunction;
    }

    private void addFunction(TFunction func) {
        this.functions2.put(func.getSignature(), func);
        this.functions3.add(func.getSignature().getFunctionName() + "(");
    }

    public void executeEndfunction() {
        this.addFunction(this.pendingFunction);
        this.pendingFunction = null;
    }
}

