/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.tim.ConditionalContext;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.EaterFunctionCall;
import net.sourceforge.plantuml.tim.EaterReturn;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TFunction;
import net.sourceforge.plantuml.tim.TFunctionArgument;
import net.sourceforge.plantuml.tim.TFunctionSignature;
import net.sourceforge.plantuml.tim.TFunctionType;
import net.sourceforge.plantuml.tim.TLineType;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.TVariable;
import net.sourceforge.plantuml.tim.expression.TValue;

public class TFunctionImpl
implements TFunction {
    private final TFunctionSignature signature;
    private final List<TFunctionArgument> args;
    private final List<StringLocated> body = new ArrayList<StringLocated>();
    private final boolean unquoted;
    private TFunctionType functionType = TFunctionType.VOID;
    private String legacyDefinition;

    public TFunctionImpl(String functionName, List<TFunctionArgument> args, boolean unquoted) {
        this.signature = new TFunctionSignature(functionName, args.size());
        this.args = args;
        this.unquoted = unquoted;
    }

    @Override
    public boolean canCover(int nbArg) {
        if (nbArg > this.args.size()) {
            return false;
        }
        for (int i = nbArg; i < this.args.size(); ++i) {
            if (this.args.get(i).getOptionalDefaultValue() != null) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "FUNCTION " + this.signature + " " + this.args;
    }

    public void addBody(StringLocated s) {
        this.body.add(s);
        if (TLineType.getFromLine(s.getString()) == TLineType.RETURN) {
            this.functionType = TFunctionType.RETURN;
        }
    }

    @Override
    public void executeVoid(TContext context, String s, TMemory memory) throws EaterException {
        if (this.functionType != TFunctionType.VOID && this.functionType != TFunctionType.LEGACY_DEFINELONG) {
            throw new IllegalStateException();
        }
        EaterFunctionCall call = new EaterFunctionCall(s, context.isLegacyDefine(this.signature.getFunctionName()), this.unquoted);
        call.execute(context, memory);
        TMemory copy = this.getNewMemory(memory, call.getValues2());
        for (StringLocated sl : this.body) {
            CommandExecutionResult exe = context.executeOneLine(copy, TLineType.getFromLine(sl.getString()), sl, TFunctionType.VOID);
            if (exe.isOk()) continue;
            throw new EaterException(exe.getError());
        }
    }

    private TMemory getNewMemory(TMemory memory, List<TValue> values) {
        TMemory copy = memory.forkFromGlobal();
        for (int i = 0; i < this.args.size(); ++i) {
            TValue tmp = i < values.size() ? values.get(i) : this.args.get(i).getOptionalDefaultValue();
            copy.put(this.args.get(i).getName(), new TVariable(tmp));
        }
        return copy;
    }

    @Override
    public TValue executeReturn(TContext context, TMemory memory, List<TValue> args) throws EaterException {
        if (this.functionType == TFunctionType.LEGACY_DEFINE) {
            return this.executeReturnLegacyDefine(context, memory, args);
        }
        if (this.functionType != TFunctionType.RETURN) {
            throw new IllegalStateException();
        }
        TMemory copy = this.getNewMemory(memory, args);
        for (StringLocated sl : this.body) {
            TLineType lineType = TLineType.getFromLine(sl.getString());
            ConditionalContext conditionalContext = copy.peekConditionalContext();
            if ((conditionalContext == null || conditionalContext.conditionIsOkHere()) && lineType == TLineType.RETURN) {
                EaterReturn eaterReturn = new EaterReturn(sl.getString());
                eaterReturn.execute(context, copy);
                return eaterReturn.getValue2();
            }
            CommandExecutionResult exe = context.executeOneLine(copy, lineType, sl, TFunctionType.RETURN);
            if (exe.isOk()) continue;
            throw new EaterException(exe.getError());
        }
        throw new EaterException("no return");
    }

    private TValue executeReturnLegacyDefine(TContext context, TMemory memory, List<TValue> args) throws EaterException {
        if (this.legacyDefinition == null) {
            throw new IllegalStateException();
        }
        TMemory copy = this.getNewMemory(memory, args);
        String tmp = context.applyFunctionsAndVariables(copy, this.legacyDefinition);
        return TValue.fromString(tmp);
    }

    @Override
    public final TFunctionType getFunctionType() {
        return this.functionType;
    }

    @Override
    public final TFunctionSignature getSignature() {
        return this.signature;
    }

    public void setFunctionType(TFunctionType type) {
        this.functionType = type;
    }

    public void setLegacyDefinition(String legacyDefinition) {
        this.legacyDefinition = legacyDefinition;
    }

    @Override
    public boolean isUnquoted() {
        return this.unquoted;
    }

    public boolean hasBody() {
        return this.body.size() > 0;
    }
}

