/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim;

public enum TLineType {
    PLAIN,
    AFFECTATION_DEFINE,
    AFFECTATION,
    ASSERT,
    IF,
    IFDEF,
    IFNDEF,
    ELSE,
    ENDIF,
    DECLARE_FUNCTION,
    END_FUNCTION,
    RETURN,
    LEGACY_DEFINE,
    LEGACY_DEFINELONG,
    INCLUDE,
    IMPORT;


    public static TLineType getFromLine(String s) {
        if (s.matches("^!define\\s+[\\p{L}_][\\p{L}_0-9]*\\(.*")) {
            return LEGACY_DEFINE;
        }
        if (s.matches("^!definelong\\s+[\\p{L}_][\\p{L}_0-9]*\\b.*")) {
            return LEGACY_DEFINELONG;
        }
        if (s.matches("^!define\\s+[\\p{L}_][\\p{L}_0-9]*\\b.*")) {
            return AFFECTATION_DEFINE;
        }
        if (s.matches("^!\\s*\\$?[\\p{L}_][\\p{L}_0-9]*\\s*=.*")) {
            return AFFECTATION;
        }
        if (s.matches("^!ifdef\\s+.*")) {
            return IFDEF;
        }
        if (s.matches("^!ifndef\\s+.*")) {
            return IFNDEF;
        }
        if (s.matches("^!assert\\s+.*")) {
            return ASSERT;
        }
        if (s.matches("^!if\\s+.*")) {
            return IF;
        }
        if (s.matches("^!(unquoted\\s)?function\\s+\\$?[\\p{L}_][\\p{L}_0-9]*.*")) {
            return DECLARE_FUNCTION;
        }
        if (s.matches("^!else\\b.*")) {
            return ELSE;
        }
        if (s.matches("^!endif\\b.*")) {
            return ENDIF;
        }
        if (s.matches("^!(endfunction|enddefinelong)\\b.*")) {
            return END_FUNCTION;
        }
        if (s.matches("^!return\\b.*")) {
            return RETURN;
        }
        if (s.matches("^!(include|includeurl)\\b.*")) {
            return INCLUDE;
        }
        if (s.matches("^!(import)\\b.*")) {
            return IMPORT;
        }
        return PLAIN;
    }

    public static boolean isQuote(char ch) {
        return ch == '\"' || ch == '\'';
    }

    public static boolean isLetterOrUnderscoreOrDigit(char ch) {
        return TLineType.isLetterOrUnderscore(ch) || TLineType.isLatinDigit(ch);
    }

    public static boolean isLetterOrUnderscore(char ch) {
        return TLineType.isLetter(ch) || ch == '_';
    }

    public static boolean isLetterOrUnderscoreOrDollar(char ch) {
        return TLineType.isLetterOrUnderscore(ch) || ch == '$';
    }

    public static boolean isLetterOrDigit(char ch) {
        return TLineType.isLetter(ch) || TLineType.isLatinDigit(ch);
    }

    public static boolean isLetter(char ch) {
        return Character.isLetter(ch);
    }

    public static boolean isSpaceChar(char ch) {
        return Character.isSpaceChar(ch);
    }

    public static boolean isLatinDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }
}

