/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.tim.ConditionalContexts;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.TMemoryGlobal;
import net.sourceforge.plantuml.tim.TVariable;
import net.sourceforge.plantuml.tim.Trie;

public class TMemoryLocal
extends ConditionalContexts
implements TMemory {
    private final TMemoryGlobal global;
    private final Map<String, TVariable> localVariables = new HashMap<String, TVariable>();
    private Trie variables;

    public TMemoryLocal(TMemoryGlobal global) {
        this.global = global;
    }

    private void initTrie() {
        for (String name : this.global.variablesNames()) {
            this.variables.add(name);
        }
    }

    @Override
    public TVariable getVariable(String varname) {
        TVariable result = this.localVariables.get(varname);
        if (result != null) {
            return result;
        }
        return this.global.getVariable(varname);
    }

    @Override
    public Trie variablesNames3() {
        if (this.variables == null) {
            return this.global.variablesNames3();
        }
        return this.variables;
    }

    @Override
    public void put(String varname, TVariable value) {
        this.localVariables.put(varname, value);
        if (this.variables == null) {
            this.variables = new Trie();
            this.initTrie();
        }
        this.variables.add(varname);
    }

    @Override
    public boolean isEmpty() {
        return this.global.isEmpty() && this.localVariables.isEmpty();
    }

    @Override
    public Set<String> variablesNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TMemory forkFromGlobal() {
        return new TMemoryLocal(this.global);
    }
}

